/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.HttpStatusCodeOutOfRangeException;

@Immutable
public final class HttpStatus {
    private static final Map<Integer, HttpStatus> ASSIGNED = new HashMap<Integer, HttpStatus>();
    public static final HttpStatus CONTINUE = HttpStatus.assign(100);
    public static final HttpStatus SWITCHING_PROTOCOLS = HttpStatus.assign(101);
    public static final HttpStatus PROCESSING = HttpStatus.assign(102);
    public static final HttpStatus EARLY_HINTS = HttpStatus.assign(103);
    public static final HttpStatus OK = HttpStatus.assign(200);
    public static final HttpStatus CREATED = HttpStatus.assign(201);
    public static final HttpStatus ACCEPTED = HttpStatus.assign(202);
    public static final HttpStatus NON_AUTHORITATIVE_INFORMATION = HttpStatus.assign(203);
    public static final HttpStatus NO_CONTENT = HttpStatus.assign(204);
    public static final HttpStatus RESET_CONTENT = HttpStatus.assign(205);
    public static final HttpStatus PARTIAL_CONTENT = HttpStatus.assign(206);
    public static final HttpStatus MULTI_STATUS = HttpStatus.assign(207);
    public static final HttpStatus ALREADY_REPORTED = HttpStatus.assign(208);
    public static final HttpStatus IM_USED = HttpStatus.assign(226);
    public static final HttpStatus MULTIPLE_CHOICES = HttpStatus.assign(300);
    public static final HttpStatus MOVED_PERMANENTLY = HttpStatus.assign(301);
    public static final HttpStatus FOUND = HttpStatus.assign(302);
    public static final HttpStatus SEE_OTHER = HttpStatus.assign(303);
    public static final HttpStatus NOT_MODIFIED = HttpStatus.assign(304);
    public static final HttpStatus USE_PROXY = HttpStatus.assign(305);
    public static final HttpStatus TEMPORARY_REDIRECT = HttpStatus.assign(307);
    public static final HttpStatus PERMANENT_REDIRECT = HttpStatus.assign(308);
    public static final HttpStatus BAD_REQUEST = HttpStatus.assign(400);
    public static final HttpStatus UNAUTHORIZED = HttpStatus.assign(401);
    public static final HttpStatus PAYMENT_REQUIRED = HttpStatus.assign(402);
    public static final HttpStatus FORBIDDEN = HttpStatus.assign(403);
    public static final HttpStatus NOT_FOUND = HttpStatus.assign(404);
    public static final HttpStatus METHOD_NOT_ALLOWED = HttpStatus.assign(405);
    public static final HttpStatus NOT_ACCEPTABLE = HttpStatus.assign(406);
    public static final HttpStatus PROXY_AUTHENTICATION_REQUIRED = HttpStatus.assign(407);
    public static final HttpStatus REQUEST_TIMEOUT = HttpStatus.assign(408);
    public static final HttpStatus CONFLICT = HttpStatus.assign(409);
    public static final HttpStatus GONE = HttpStatus.assign(410);
    public static final HttpStatus LENGTH_REQUIRED = HttpStatus.assign(411);
    public static final HttpStatus PRECONDITION_FAILED = HttpStatus.assign(412);
    public static final HttpStatus REQUEST_ENTITY_TOO_LARGE = HttpStatus.assign(413);
    public static final HttpStatus REQUEST_URI_TOO_LONG = HttpStatus.assign(414);
    public static final HttpStatus UNSUPPORTED_MEDIA_TYPE = HttpStatus.assign(415);
    public static final HttpStatus REQUESTED_RANGE_NOT_SATISFIABLE = HttpStatus.assign(416);
    public static final HttpStatus EXPECTATION_FAILED = HttpStatus.assign(417);
    public static final HttpStatus IM_A_TEAPOT = HttpStatus.assign(418);
    public static final HttpStatus MISDIRECTED_REQUEST = HttpStatus.assign(421);
    public static final HttpStatus UNPROCESSABLE_ENTITY = HttpStatus.assign(422);
    public static final HttpStatus LOCKED = HttpStatus.assign(423);
    public static final HttpStatus FAILED_DEPENDENCY = HttpStatus.assign(424);
    public static final HttpStatus TOO_EARLY = HttpStatus.assign(425);
    public static final HttpStatus UPGRADE_REQUIRED = HttpStatus.assign(426);
    public static final HttpStatus PRECONDITION_REQUIRED = HttpStatus.assign(428);
    public static final HttpStatus TOO_MANY_REQUESTS = HttpStatus.assign(429);
    public static final HttpStatus REQUEST_HEADER_FIELDS_TOO_LARGE = HttpStatus.assign(431);
    public static final HttpStatus UNAVAILABLE_FOR_LEGAL_REASONS = HttpStatus.assign(451);
    public static final HttpStatus INTERNAL_SERVER_ERROR = HttpStatus.assign(500);
    public static final HttpStatus NOT_IMPLEMENTED = HttpStatus.assign(501);
    @Deprecated
    public static final HttpStatus BAD_GATEWAY = HttpStatus.assign(502);
    public static final HttpStatus SERVICE_UNAVAILABLE = HttpStatus.assign(503);
    public static final HttpStatus GATEWAY_TIMEOUT = HttpStatus.assign(504);
    public static final HttpStatus HTTPVERSION_NOT_SUPPORTED = HttpStatus.assign(505);
    public static final HttpStatus VARIANT_ALSO_NEGOTIATES = HttpStatus.assign(506);
    public static final HttpStatus INSUFFICIENT_STORAGE = HttpStatus.assign(507);
    public static final HttpStatus LOOP_DETECTED = HttpStatus.assign(508);
    public static final HttpStatus NOT_EXTENDED = HttpStatus.assign(510);
    public static final HttpStatus NETWORK_AUTHENTICATION_REQUIRED = HttpStatus.assign(511);
    public static final HttpStatus NETWORK_CONNECT_TIMEOUT = HttpStatus.assign(599);
    private final int code;
    private final Category category;

    private HttpStatus(int code, Category category) {
        this.code = code;
        this.category = category;
    }

    public static Optional<HttpStatus> tryGetInstance(int code) {
        HttpStatus httpStatus;
        try {
            httpStatus = HttpStatus.getInstance(code);
        }
        catch (HttpStatusCodeOutOfRangeException e) {
            httpStatus = null;
        }
        return Optional.ofNullable(httpStatus);
    }

    public static HttpStatus getInstance(int code) throws HttpStatusCodeOutOfRangeException {
        HttpStatus result = ASSIGNED.get(code);
        if (null == result) {
            result = HttpStatus.newInstance(code);
        }
        return result;
    }

    private static HttpStatus newInstance(int code) throws HttpStatusCodeOutOfRangeException {
        return new HttpStatus(code, Category.of(code).orElseThrow(() -> new HttpStatusCodeOutOfRangeException(code)));
    }

    private static HttpStatus assign(int code) {
        HttpStatus result = HttpStatus.tryToCreateInstance(code);
        ASSIGNED.put(code, result);
        return result;
    }

    private static HttpStatus tryToCreateInstance(int code) {
        try {
            return HttpStatus.newInstance(code);
        }
        catch (HttpStatusCodeOutOfRangeException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getCode() {
        return this.code;
    }

    public boolean isInformational() {
        return Category.INFORMATIONAL == this.category;
    }

    public boolean isSuccess() {
        return Category.SUCCESS == this.category;
    }

    public boolean isRedirection() {
        return Category.REDIRECTION == this.category;
    }

    public boolean isClientError() {
        return Category.CLIENT_ERROR == this.category;
    }

    public boolean isServerError() {
        return Category.SERVER_ERROR == this.category;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpStatus that = (HttpStatus)o;
        return this.code == that.code && this.category == that.category;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.category});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [code=" + this.code + ", category=" + (Object)((Object)this.category) + "]";
    }

    static enum Category {
        INFORMATIONAL,
        SUCCESS,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR;

        private static final byte ORDINAL_TO_STATUS_CODE_OFFSET = 100;
        private static final byte UPPER_BOUND_OFFSET = 99;

        static Optional<Category> of(int code) {
            for (Category category : Category.values()) {
                int ordinal = category.ordinal();
                int lowerBound = (ordinal + 1) * 100;
                int upperBound = lowerBound + 99;
                if (lowerBound > code || code > upperBound) continue;
                return Optional.of(category);
            }
            return Optional.empty();
        }
    }
}

