/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.common;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ByteBufferUtils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private ByteBufferUtils() {
        throw new AssertionError();
    }

    public static ByteBuffer clone(ByteBuffer original) {
        if (original.remaining() == 0) {
            return ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
        }
        ByteBuffer clone = ByteBuffer.allocate(original.remaining());
        if (original.hasArray()) {
            System.arraycopy(original.array(), original.arrayOffset() + original.position(), clone.array(), 0, original.remaining());
        } else {
            clone.put(original.duplicate());
            clone.flip();
        }
        return clone;
    }

    public static ByteBuffer empty() {
        return ByteBuffer.allocate(0);
    }

    @Nullable
    public static ByteBuffer fromUtf8String(@Nullable String string) {
        if (null == string) {
            return null;
        }
        return ByteBuffer.wrap(string.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public static String toUtf8String(@Nullable ByteBuffer byteBuffer) {
        return ByteBufferUtils.toString(byteBuffer, StandardCharsets.UTF_8);
    }

    @Nullable
    public static String toString(@Nullable ByteBuffer value, Charset charset) {
        if (null == value) {
            return null;
        }
        return charset.decode(value.asReadOnlyBuffer()).toString();
    }
}

