/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.common;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.IdValidator;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;

public abstract class AbstractIdValidator
implements BiConsumer<CharSequence, DittoHeaders> {
    private final String idRegex;

    protected AbstractIdValidator(String idRegex) {
        this.idRegex = ConditionChecker.checkNotNull(idRegex, "idRegex");
    }

    @Override
    public void accept(@Nullable CharSequence id, DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(dittoHeaders, "Ditto Headers");
        IdValidator idValidator = IdValidator.newInstance(id, this.idRegex);
        if (!idValidator.isValid()) {
            DittoRuntimeExceptionBuilder<?> builder = this.createExceptionBuilder(id).dittoHeaders(dittoHeaders);
            idValidator.getReason().ifPresent(builder::message);
            throw builder.build();
        }
    }

    protected abstract DittoRuntimeExceptionBuilder<?> createExceptionBuilder(@Nullable CharSequence var1);
}

