/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.auth.AuthorizationContext;
import org.eclipse.ditto.base.model.auth.AuthorizationContextType;
import org.eclipse.ditto.base.model.auth.AuthorizationModelFactory;
import org.eclipse.ditto.base.model.auth.AuthorizationSubject;
import org.eclipse.ditto.base.model.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.base.model.auth.ImmutableAuthorizationContextType;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ImmutableAuthorizationContext
implements AuthorizationContext {
    private final AuthorizationContextType type;
    private final List<AuthorizationSubject> authorizationSubjects;
    @Nullable
    private List<String> authorizationSubjectIds;

    private ImmutableAuthorizationContext(AuthorizationContextType type, List<AuthorizationSubject> authorizationSubjects) {
        this.type = type;
        this.authorizationSubjects = authorizationSubjects;
        this.authorizationSubjectIds = null;
    }

    public static ImmutableAuthorizationContext of(AuthorizationContextType type, List<AuthorizationSubject> authorizationSubjects) {
        ConditionChecker.checkNotNull(type, "type");
        ConditionChecker.checkNotNull(authorizationSubjects, "authorization subjects");
        return new ImmutableAuthorizationContext(type, Collections.unmodifiableList(authorizationSubjects));
    }

    public static ImmutableAuthorizationContext of(AuthorizationContextType type, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        ConditionChecker.checkNotNull(type, "type");
        ConditionChecker.checkNotNull(authorizationSubject, "mandatory authorization subject");
        ConditionChecker.checkNotNull(furtherAuthorizationSubjects, "additional authorization subjects");
        ArrayList<AuthorizationSubject> allAuthSubjects = new ArrayList<AuthorizationSubject>(1 + furtherAuthorizationSubjects.length);
        allAuthSubjects.add(authorizationSubject);
        Collections.addAll(allAuthSubjects, furtherAuthorizationSubjects);
        return new ImmutableAuthorizationContext(type, allAuthSubjects);
    }

    public static ImmutableAuthorizationContext fromJson(JsonObject jsonObject) {
        if (jsonObject.isEmpty()) {
            return ImmutableAuthorizationContext.of(DittoAuthorizationContextType.UNSPECIFIED, Collections.emptyList());
        }
        ImmutableAuthorizationContextType type = ImmutableAuthorizationContextType.of((CharSequence)jsonObject.getValueOrThrow(AuthorizationContext.JsonFields.TYPE));
        List<AuthorizationSubject> authSubjects = ((JsonArray)jsonObject.getValueOrThrow(AuthorizationContext.JsonFields.AUTH_SUBJECTS)).stream().map(JsonValue::asString).map(AuthorizationModelFactory::newAuthSubject).collect(Collectors.toList());
        return ImmutableAuthorizationContext.of(type, authSubjects);
    }

    @Override
    public AuthorizationContextType getType() {
        return this.type;
    }

    @Override
    public List<AuthorizationSubject> getAuthorizationSubjects() {
        return this.authorizationSubjects;
    }

    @Override
    public List<String> getAuthorizationSubjectIds() {
        List<String> result = this.authorizationSubjectIds;
        if (null == result) {
            this.authorizationSubjectIds = result = Collections.unmodifiableList(this.authorizationSubjects.stream().map(AuthorizationSubject::getId).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public Optional<AuthorizationSubject> getFirstAuthorizationSubject() {
        try {
            return Optional.of(this.authorizationSubjects.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    @Override
    public int getSize() {
        return this.authorizationSubjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.authorizationSubjects.isEmpty();
    }

    @Override
    public AuthorizationContext addHead(List<AuthorizationSubject> authorizationSubjects) {
        ConditionChecker.checkNotNull(authorizationSubjects, "authorizationSubjects");
        ArrayList<AuthorizationSubject> newAuthorizationSubjects = new ArrayList<AuthorizationSubject>(this.authorizationSubjects.size() + authorizationSubjects.size());
        newAuthorizationSubjects.addAll(authorizationSubjects);
        newAuthorizationSubjects.addAll(this.authorizationSubjects);
        return new ImmutableAuthorizationContext(this.type, newAuthorizationSubjects);
    }

    @Override
    public AuthorizationContext addTail(List<AuthorizationSubject> authorizationSubjects) {
        ConditionChecker.checkNotNull(authorizationSubjects, "authorizationSubjects");
        ArrayList<AuthorizationSubject> newAuthorizationSubjects = new ArrayList<AuthorizationSubject>(this.authorizationSubjects.size() + authorizationSubjects.size());
        newAuthorizationSubjects.addAll(this.authorizationSubjects);
        newAuthorizationSubjects.addAll(authorizationSubjects);
        return new ImmutableAuthorizationContext(this.type, newAuthorizationSubjects);
    }

    @Override
    public boolean isAuthorized(Collection<AuthorizationSubject> granted, Collection<AuthorizationSubject> revoked) {
        ConditionChecker.checkNotNull(granted, "granted");
        ConditionChecker.checkNotNull(revoked, "revoked");
        boolean isGranted = !Collections.disjoint(granted, this.authorizationSubjects);
        boolean isRevoked = !Collections.disjoint(revoked, this.authorizationSubjects);
        return isGranted && !isRevoked;
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().set(AuthorizationContext.JsonFields.TYPE, (Object)this.type.toString(), predicate).set(AuthorizationContext.JsonFields.AUTH_SUBJECTS, (Object)this.authorizedSubjectsToJson(), predicate).build();
    }

    private JsonArray authorizedSubjectsToJson() {
        return (JsonArray)this.authorizationSubjects.stream().map(AuthorizationSubject::getId).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray());
    }

    @Override
    public Iterator<AuthorizationSubject> iterator() {
        return new ArrayList<AuthorizationSubject>(this.authorizationSubjects).iterator();
    }

    @Override
    public Stream<AuthorizationSubject> stream() {
        return this.authorizationSubjects.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAuthorizationContext that = (ImmutableAuthorizationContext)o;
        return this.type.equals(that.type) && this.authorizationSubjects.equals(that.authorizationSubjects);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.authorizationSubjects);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type=" + this.type + ", authorizationSubjects=" + this.authorizationSubjects + "]";
    }
}

