/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.auth;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.auth.AuthorizationContext;
import org.eclipse.ditto.base.model.auth.AuthorizationContextType;
import org.eclipse.ditto.base.model.auth.AuthorizationSubject;
import org.eclipse.ditto.base.model.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.base.model.auth.ImmutableAuthorizationContext;
import org.eclipse.ditto.base.model.auth.ImmutableAuthorizationSubject;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.json.JsonObject;

@Immutable
public final class AuthorizationModelFactory {
    private AuthorizationModelFactory() {
        throw new AssertionError();
    }

    public static AuthorizationSubject newAuthSubject(CharSequence identifier) {
        return ImmutableAuthorizationSubject.of(identifier);
    }

    public static AuthorizationContext emptyAuthContext() {
        return ImmutableAuthorizationContext.of(DittoAuthorizationContextType.UNSPECIFIED, Collections.emptyList());
    }

    public static AuthorizationContext newAuthContext(AuthorizationContextType type, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return ImmutableAuthorizationContext.of(type, authorizationSubject, furtherAuthorizationSubjects);
    }

    public static AuthorizationContext newAuthContext(JsonObject jsonObject) {
        return DittoJsonException.wrapJsonRuntimeException(() -> ImmutableAuthorizationContext.fromJson(jsonObject));
    }

    public static AuthorizationContext newAuthContext(AuthorizationContextType type, Iterable<AuthorizationSubject> authorizationSubjects) {
        ArrayList<AuthorizationSubject> authSubjectsList = new ArrayList<AuthorizationSubject>();
        authorizationSubjects.forEach(authSubjectsList::add);
        return ImmutableAuthorizationContext.of(type, authSubjectsList);
    }
}

