/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.auth;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.auth.AuthorizationContextType;
import org.eclipse.ditto.base.model.auth.AuthorizationModelFactory;
import org.eclipse.ditto.base.model.auth.AuthorizationSubject;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;

@Immutable
public interface AuthorizationContext
extends Iterable<AuthorizationSubject>,
Jsonifiable.WithPredicate<JsonObject, JsonField> {
    public static AuthorizationContext newInstance(AuthorizationContextType type, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return AuthorizationModelFactory.newAuthContext(type, authorizationSubject, furtherAuthorizationSubjects);
    }

    public static AuthorizationContext newInstance(AuthorizationContextType type, Iterable<AuthorizationSubject> authorizationSubjects) {
        return AuthorizationModelFactory.newAuthContext(type, authorizationSubjects);
    }

    public static AuthorizationContext empty() {
        return AuthorizationModelFactory.emptyAuthContext();
    }

    public AuthorizationContextType getType();

    public List<AuthorizationSubject> getAuthorizationSubjects();

    public AuthorizationContext addHead(List<AuthorizationSubject> var1);

    public AuthorizationContext addTail(List<AuthorizationSubject> var1);

    default public List<String> getAuthorizationSubjectIds() {
        return this.getAuthorizationSubjects().stream().map(AuthorizationSubject::getId).collect(Collectors.toList());
    }

    public Optional<AuthorizationSubject> getFirstAuthorizationSubject();

    public int getSize();

    public boolean isEmpty();

    public Stream<AuthorizationSubject> stream();

    public boolean isAuthorized(Collection<AuthorizationSubject> var1, Collection<AuthorizationSubject> var2);

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> AUTH_SUBJECTS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"subjects", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

