/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.FatalPubSubException;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="pubsub:abnormal.termination")
@Immutable
public final class PubSubTerminatedException
extends DittoRuntimeException
implements FatalPubSubException {
    public static final String ERROR_CODE = "pubsub:abnormal.termination";
    private static final String DEFAULT_MESSAGE = "The signal pubsub infrastructure terminated abnormally.";
    private static final String DEFAULT_DESCRIPTION = "Please try again later.";
    private static final PubSubTerminatedException INSTANCE = (PubSubTerminatedException)PubSubTerminatedException.newBuilder().build();

    private PubSubTerminatedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.INTERNAL_SERVER_ERROR, dittoHeaders, message, description, cause, href);
    }

    public static PubSubTerminatedException getInstance() {
        return INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PubSubTerminatedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public DittoRuntimeException asDittoRuntimeException() {
        return this;
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PubSubTerminatedException> {
        private Builder() {
            this.message(PubSubTerminatedException.DEFAULT_MESSAGE);
            this.description(PubSubTerminatedException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected PubSubTerminatedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PubSubTerminatedException(dittoHeaders, message, description, cause, href);
        }
    }
}

