/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.AcknowledgementRequest;
import org.eclipse.ditto.base.model.acks.FilteredAcknowledgementRequest;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class ImmutableFilteredAcknowledgementRequest
implements FilteredAcknowledgementRequest {
    private final Set<AcknowledgementRequest> includes;
    @Nullable
    private final String filter;

    private ImmutableFilteredAcknowledgementRequest(Set<AcknowledgementRequest> includes, @Nullable String filter) {
        this.includes = Collections.unmodifiableSet(new HashSet<AcknowledgementRequest>(includes));
        this.filter = filter;
    }

    static ImmutableFilteredAcknowledgementRequest getInstance(Set<AcknowledgementRequest> includes, @Nullable String filter) {
        return new ImmutableFilteredAcknowledgementRequest(ConditionChecker.checkNotNull(includes, "includes"), filter);
    }

    @Override
    public Set<AcknowledgementRequest> getIncludes() {
        return this.includes;
    }

    @Override
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public static FilteredAcknowledgementRequest fromJson(JsonObject jsonObject) {
        return FilteredAcknowledgementRequest.of(jsonObject.getValue(FilteredAcknowledgementRequest.JsonFields.INCLUDES).orElse(JsonArray.empty()).stream().filter(JsonValue::isString).map(JsonValue::asString).map(AcknowledgementRequest::parseAcknowledgementRequest).collect(Collectors.toSet()), jsonObject.getValue(FilteredAcknowledgementRequest.JsonFields.FILTER).orElse(null));
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(FilteredAcknowledgementRequest.JsonFields.INCLUDES, (Object)((JsonArray)this.includes.stream().map(AcknowledgementRequest::getLabel).map(AcknowledgementLabel::toString).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate);
        if (this.filter != null) {
            jsonObjectBuilder.set(FilteredAcknowledgementRequest.JsonFields.FILTER, (Object)this.filter, predicate);
        }
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFilteredAcknowledgementRequest that = (ImmutableFilteredAcknowledgementRequest)o;
        return Objects.equals(this.includes, that.includes) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.includes, this.filter);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [includes=" + this.includes + ", filter=" + this.filter + "]";
    }
}

