/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.AcknowledgementRequest;
import org.eclipse.ditto.base.model.common.ConditionChecker;

@Immutable
final class ImmutableAcknowledgementRequest
implements AcknowledgementRequest {
    private final AcknowledgementLabel label;

    private ImmutableAcknowledgementRequest(AcknowledgementLabel label) {
        this.label = label;
    }

    public static ImmutableAcknowledgementRequest getInstance(AcknowledgementLabel acknowledgementLabel) {
        return new ImmutableAcknowledgementRequest(ConditionChecker.checkNotNull(acknowledgementLabel, "acknowledgementLabel"));
    }

    @Override
    public AcknowledgementLabel getLabel() {
        return this.label;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAcknowledgementRequest that = (ImmutableAcknowledgementRequest)o;
        return this.label.equals(that.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    @Override
    public String toString() {
        return this.label.toString();
    }
}

