/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.AcknowledgementException;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="acknowledgement:ditto.acklabel.forbidden")
@Immutable
public final class DittoAcknowledgementLabelExternalUseForbiddenException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:ditto.acklabel.forbidden";
    private static final String MESSAGE_TEMPLATE = "The Ditto internal Acknowledgement label <{0}> is not allowed to be issued externally!";
    private static final String DEFAULT_DESCRIPTION = "Make sure to not issue an Ditto internal Acknowledgement label.";
    private static final long serialVersionUID = 7892643278643243248L;

    private DittoAcknowledgementLabelExternalUseForbiddenException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public DittoAcknowledgementLabelExternalUseForbiddenException(CharSequence label) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, label), DEFAULT_DESCRIPTION, null, null);
    }

    public static DittoAcknowledgementLabelExternalUseForbiddenException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoAcknowledgementLabelExternalUseForbiddenException> {
        private Builder() {
            this.description(DittoAcknowledgementLabelExternalUseForbiddenException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected DittoAcknowledgementLabelExternalUseForbiddenException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoAcknowledgementLabelExternalUseForbiddenException(dittoHeaders, message, description, cause, href);
        }
    }
}

