/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.AcknowledgementException;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="acknowledgement:request.parsing.failed")
@Immutable
public final class AcknowledgementRequestParseException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:request.parsing.failed";
    static final String MESSAGE_TEMPLATE = "<{0}> cannot be parsed to an acknowledgement request!";
    static final String DEFAULT_DESCRIPTION = "The string to be parsed must be a valid representation of an acknowledgement request.";
    private static final long serialVersionUID = 6452961856865574058L;

    private AcknowledgementRequestParseException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.UNPROCESSABLE_ENTITY, dittoHeaders, message, description, cause, href);
    }

    public AcknowledgementRequestParseException(CharSequence ackRequestString, @Nullable Throwable cause, DittoHeaders dittoHeaders) {
        this(dittoHeaders, AcknowledgementRequestParseException.getMessageIncludingCause(ackRequestString, cause), DEFAULT_DESCRIPTION, cause, null);
    }

    private static String getMessageIncludingCause(CharSequence ackRequestString, @Nullable Throwable cause) {
        String result = MessageFormat.format(MESSAGE_TEMPLATE, ackRequestString);
        if (null != cause) {
            result = result + " Cause: " + cause.getMessage();
        }
        return result;
    }

    public static AcknowledgementRequestParseException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    private static class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementRequestParseException> {
        private Builder() {
            this.description(AcknowledgementRequestParseException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AcknowledgementRequestParseException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementRequestParseException(dittoHeaders, message, description, cause, href);
        }
    }
}

