/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.acks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabelInvalidException;
import org.eclipse.ditto.base.model.acks.ImmutableAcknowledgementLabel;
import org.eclipse.ditto.base.model.common.ConditionChecker;

@Immutable
final class AcknowledgementLabels {
    private static final String PLACEHOLDER_GROUP = "placeholder";
    public static final String ACK_LABEL_REGEX = "(?<placeholder>\\{\\{\\w*[a-z]+:[a-z]+\\w*}}:)?[a-zA-Z0-9-_:]{3,165}";
    private static final Pattern ACK_LABEL_PATTERN = Pattern.compile("(?<placeholder>\\{\\{\\w*[a-z]+:[a-z]+\\w*}}:)?[a-zA-Z0-9-_:]{3,165}");

    private AcknowledgementLabels() {
        throw new AssertionError();
    }

    public static AcknowledgementLabel newLabel(CharSequence label) {
        if (label instanceof AcknowledgementLabel) {
            return (AcknowledgementLabel)label;
        }
        AcknowledgementLabels.validateLabel(ConditionChecker.checkNotNull(label, "label"));
        return ImmutableAcknowledgementLabel.of(label);
    }

    static boolean isFullyResolved(AcknowledgementLabel label) {
        Matcher labelRegexMatcher = ACK_LABEL_PATTERN.matcher(label);
        if (labelRegexMatcher.matches()) {
            String placeholder = labelRegexMatcher.group(PLACEHOLDER_GROUP);
            return null == placeholder || placeholder.isEmpty();
        }
        throw new AcknowledgementLabelInvalidException(label);
    }

    private static void validateLabel(CharSequence label) {
        Matcher labelRegexMatcher = ACK_LABEL_PATTERN.matcher(label);
        if (!labelRegexMatcher.matches()) {
            throw new AcknowledgementLabelInvalidException(label);
        }
    }
}

