/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.entity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.records.SelectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryProcessor<T>
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceQueryProcessor.class);

    public PersistenceQueryProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        throw new PersistenceException("Generate Script method cannot be invoked in Query Processor");
    }

    protected String generateScriptFind(Connection connection, PersistenceTableModel tableModel) {
        SelectBuilder selectBuilder = SqlFactory.getNative((Connection)connection).select().column("*").from(tableModel.getTableName());
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!columnModel.isPrimaryKey()) continue;
            selectBuilder.where(columnModel.getName() + " " + "=" + " " + "?");
            break;
        }
        String sql = selectBuilder.toString();
        logger.trace(sql);
        return sql;
    }

    protected String generateScriptLock(Connection connection, PersistenceTableModel tableModel) {
        SelectBuilder selectBuilder = SqlFactory.getNative((Connection)connection).select().column("*").from(tableModel.getTableName());
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!columnModel.isPrimaryKey()) continue;
            selectBuilder.where(columnModel.getName() + " " + "=" + " " + "?");
            break;
        }
        selectBuilder.forUpdate();
        String sql = selectBuilder.build();
        logger.trace(sql);
        return sql;
    }

    protected String generateScriptFindAll(Connection connection, PersistenceTableModel tableModel) {
        SelectBuilder selectBuilder = SqlFactory.getNative((Connection)connection).select().column("*").from(tableModel.getTableName());
        String sql = selectBuilder.toString();
        logger.trace(sql);
        return sql;
    }

    public T find(Connection connection, PersistenceTableModel tableModel, Class<T> clazz, Object id) throws PersistenceException {
        logger.trace("find -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", class: " + clazz.getCanonicalName() + ", id: " + id);
        String sql = this.generateScriptFind(connection, tableModel);
        return this.get(connection, tableModel, clazz, id, sql);
    }

    public T lock(Connection connection, PersistenceTableModel tableModel, Class<T> clazz, Object id) throws PersistenceException {
        logger.trace("lock -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", class: " + clazz.getCanonicalName() + ", id: " + id);
        String sql = this.generateScriptLock(connection, tableModel);
        return this.get(connection, tableModel, clazz, id, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected T get(Connection connection, PersistenceTableModel tableModel, Class<T> clazz, Object id, String sql) throws PersistenceException {
        PreparedStatement preparedStatement;
        T result;
        block13: {
            ResultSet resultSet;
            block11: {
                T t;
                block12: {
                    logger.trace("get -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", class: " + clazz.getCanonicalName() + ", id: " + id + ", sql: " + sql);
                    result = null;
                    preparedStatement = null;
                    result = clazz.newInstance();
                    preparedStatement = this.openPreparedStatement(connection, sql);
                    this.setValuePrimaryKey(tableModel, id, preparedStatement);
                    resultSet = null;
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
                            this.setValueToPojo(result, resultSet, columnModel);
                        }
                        break block11;
                    }
                    t = null;
                    if (resultSet == null) break block12;
                    resultSet.close();
                }
                this.closePreparedStatement(preparedStatement);
                return t;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block13;
                {
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new PersistenceException(sql, e);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(preparedStatement);
                    throw throwable;
                }
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findAll(Connection connection, PersistenceTableModel tableModel, Class<T> clazz) throws PersistenceException {
        logger.trace("findAll -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", class: " + clazz.getCanonicalName());
        ArrayList<T> result = new ArrayList<T>();
        String sql = null;
        PreparedStatement preparedStatement = null;
        try {
            sql = this.generateScriptFindAll(connection, tableModel);
            preparedStatement = this.openPreparedStatement(connection, sql);
            try (ResultSet resultSet = null;){
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    T pojo = clazz.newInstance();
                    for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
                        this.setValueToPojo(pojo, resultSet, columnModel);
                    }
                    result.add(pojo);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new PersistenceException(sql, e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(preparedStatement);
                throw throwable;
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> query(Connection connection, PersistenceTableModel tableModel, Class<T> clazz, String sql, List<Object> values) {
        logger.trace("query -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", class: " + clazz.getCanonicalName() + ", sql: " + sql + ", values: " + Serializer.serializeListOfObjects(values));
        ArrayList<T> result = new ArrayList<T>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.openPreparedStatement(connection, sql);
            if (values != null) {
                int i = 1;
                for (Object value : values) {
                    this.setValue(preparedStatement, i++, value);
                }
            }
            try (ResultSet resultSet = null;){
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    T pojo = clazz.newInstance();
                    for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
                        this.setValueToPojo(pojo, resultSet, columnModel);
                    }
                    result.add(pojo);
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.closePreparedStatement(preparedStatement);
        }
        return result;
    }
}

