/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.entity;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.persistence.GenerationType;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.persistence.processors.identity.PersistenceNextValueIdentityProcessor;
import org.eclipse.dirigible.database.persistence.processors.sequence.PersistenceNextValueSequenceProcessor;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceInsertProcessor<T>
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceInsertProcessor.class);

    public PersistenceInsertProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        InsertBuilder insertBuilder = SqlFactory.getNative((ISqlDialect)SqlFactory.deriveDialect((Connection)connection)).insert().into(tableModel.getTableName());
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (columnModel.isIdentity()) continue;
            insertBuilder.column(columnModel.getName());
        }
        String sql = insertBuilder.build();
        logger.trace(sql);
        return sql;
    }

    public Object insert(Connection connection, PersistenceTableModel tableModel, T pojo) throws PersistenceException {
        PreparedStatement preparedStatement;
        Object result;
        block20: {
            logger.trace("insert -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", pojo: " + Serializer.serializePojo(pojo));
            result = 0;
            String sql = null;
            preparedStatement = null;
            try {
                boolean identified = this.setGeneratedValues(connection, tableModel, pojo);
                if (identified) {
                    sql = this.generateScript(connection, tableModel);
                    preparedStatement = this.openPreparedStatement(connection, sql);
                    this.setValuesFromPojo(tableModel, pojo, preparedStatement);
                    preparedStatement.executeUpdate();
                    result = this.getPrimaryKeyValue(tableModel, pojo);
                    break block20;
                }
                sql = this.generateScript(connection, tableModel);
                preparedStatement = connection.prepareStatement(sql, 1);
                this.setValuesFromPojo(tableModel, pojo, preparedStatement);
                int affectedRows = preparedStatement.executeUpdate();
                if (affectedRows == 0) {
                    throw new SQLException("No rows affected.");
                }
                try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                    if (generatedKeys.next()) {
                        result = generatedKeys.getLong(1);
                        for (PersistenceTableColumnModel column : tableModel.getColumns()) {
                            if (!column.isPrimaryKey() || !column.isIdentity()) continue;
                            this.setValueToPojo(pojo, result, column);
                            break block20;
                        }
                        break block20;
                    }
                    throw new SQLException("Creating user failed, no ID obtained.");
                }
            }
            catch (Exception e) {
                try {
                    logger.error(sql);
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new PersistenceException(sql, e);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(preparedStatement);
                    throw throwable;
                }
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }

    private boolean setGeneratedValues(Connection connection, PersistenceTableModel tableModel, Object pojo) throws NoSuchFieldException, IllegalAccessException, SQLException, IOException {
        logger.trace("setGeneratedValues -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", pojo: " + Serializer.serializePojo(pojo));
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!columnModel.isPrimaryKey() || columnModel.getGenerated() == null) continue;
            long id = -1L;
            if (GenerationType.SEQUENCE.name().equals(columnModel.getGenerated())) {
                PersistenceNextValueSequenceProcessor persistenceNextValueSequenceProcessor = new PersistenceNextValueSequenceProcessor(this.getEntityManagerInterceptor());
                id = persistenceNextValueSequenceProcessor.nextval(connection, tableModel);
            } else if (GenerationType.TABLE.name().equals(columnModel.getGenerated())) {
                PersistenceNextValueIdentityProcessor persistenceNextValueIdentityProcessor = new PersistenceNextValueIdentityProcessor(this.getEntityManagerInterceptor());
                id = persistenceNextValueIdentityProcessor.nextval(connection, tableModel);
            } else {
                if (GenerationType.IDENTITY.name().equals(columnModel.getGenerated())) {
                    return false;
                }
                throw new IllegalArgumentException(MessageFormat.format("Generation Type: [{0}] not supported.", columnModel.getGenerated()));
            }
            this.setValueToPojo(pojo, id, columnModel);
        }
        return true;
    }

    private Object getPrimaryKeyValue(PersistenceTableModel tableModel, Object pojo) throws NoSuchFieldException, IllegalAccessException, SQLException {
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!columnModel.isPrimaryKey()) continue;
            return this.getValueFromPojo(pojo, columnModel);
        }
        return null;
    }
}

