/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.entity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceExecuteProcessor<T>
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceExecuteProcessor.class);

    public PersistenceExecuteProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        throw new PersistenceException("Generate Script method cannot be invoked in Query Processor");
    }

    public int execute(Connection connection, String sql, List<Object> values) {
        logger.trace("execute -> connection: " + connection.hashCode() + ", sql: " + sql + ", values: " + Serializer.serializeListOfObjects(values));
        PreparedStatement preparedStatement = null;
        try {
            int i;
            preparedStatement = this.openPreparedStatement(connection, sql);
            if (values != null) {
                i = 1;
                for (Object value : values) {
                    this.setValue(preparedStatement, i++, value);
                }
            }
            i = preparedStatement.executeUpdate();
            return i;
        }
        catch (Exception e) {
            logger.error(sql);
            logger.error(e.getMessage(), (Throwable)e);
            throw new PersistenceException(e);
        }
        finally {
            this.closePreparedStatement(preparedStatement);
        }
    }
}

