/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.GenerationType;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.PersistenceFactory;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.entity.PersistenceDeleteProcessor;
import org.eclipse.dirigible.database.persistence.processors.entity.PersistenceExecuteProcessor;
import org.eclipse.dirigible.database.persistence.processors.entity.PersistenceInsertProcessor;
import org.eclipse.dirigible.database.persistence.processors.entity.PersistenceQueryProcessor;
import org.eclipse.dirigible.database.persistence.processors.entity.PersistenceUpdateProcessor;
import org.eclipse.dirigible.database.persistence.processors.identity.PersistenceCreateIdentityProcessor;
import org.eclipse.dirigible.database.persistence.processors.sequence.PersistenceCreateSequenceProcessor;
import org.eclipse.dirigible.database.persistence.processors.sequence.PersistenceDropSequenceProcessor;
import org.eclipse.dirigible.database.persistence.processors.table.PersistenceCreateTableProcessor;
import org.eclipse.dirigible.database.persistence.processors.table.PersistenceDropTableProcessor;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceManager.class);
    private static final String CONNECTION_ID_SEPARATOR = ":";
    private static final List<String> EXISTING_TABLES_CACHE = Collections.synchronizedList(new ArrayList());
    private IEntityManagerInterceptor entityManagerInterceptor;

    public int tableCreate(Connection connection, Class<T> clazz) {
        logger.trace("tableCreate -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName());
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (columnModel.getGenerated() == null) continue;
            if (GenerationType.SEQUENCE.name().equals(columnModel.getGenerated())) {
                ISqlDialect dialect = SqlFactory.deriveDialect((Connection)connection);
                if (dialect.isSequenceSupported()) {
                    PersistenceCreateSequenceProcessor persistenceCreateSequenceProcessor = new PersistenceCreateSequenceProcessor(this.getEntityManagerInterceptor());
                    persistenceCreateSequenceProcessor.create(connection, tableModel);
                    break;
                }
                throw new IllegalArgumentException(MessageFormat.format("Generation Type: [{0}] not supported for database: [{1}] by using the dialect: [{2}].", columnModel.getGenerated(), dialect.getDatabaseName(connection), dialect.getClass().getSimpleName()));
            }
            if (GenerationType.TABLE.name().equals(columnModel.getGenerated())) {
                PersistenceCreateIdentityProcessor persistenceCreateIdentityProcessor = new PersistenceCreateIdentityProcessor(this.getEntityManagerInterceptor());
                persistenceCreateIdentityProcessor.create(connection, tableModel);
                break;
            }
            if (GenerationType.IDENTITY.name().equals(columnModel.getGenerated())) break;
            throw new IllegalArgumentException(MessageFormat.format("Generation Type: [{0}] not supported.", columnModel.getGenerated()));
        }
        PersistenceCreateTableProcessor createTableProcessor = new PersistenceCreateTableProcessor(this.getEntityManagerInterceptor());
        return createTableProcessor.create(connection, tableModel);
    }

    public int tableDrop(Connection connection, Class<T> clazz) {
        logger.trace("tableDrop -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName());
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!GenerationType.SEQUENCE.name().equals(columnModel.getGenerated())) continue;
            PersistenceDropSequenceProcessor persistenceDropSequenceProcessor = new PersistenceDropSequenceProcessor(this.getEntityManagerInterceptor());
            persistenceDropSequenceProcessor.drop(connection, tableModel);
            break;
        }
        PersistenceDropTableProcessor dropTableProcessor = new PersistenceDropTableProcessor(this.getEntityManagerInterceptor());
        int result = dropTableProcessor.drop(connection, tableModel);
        this.reset(connection, clazz);
        return result;
    }

    public boolean tableExists(Connection connection, Class<T> clazz) {
        logger.trace("tableExists -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName());
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        try {
            return SqlFactory.getNative((Connection)connection).exists(connection, tableModel.getTableName());
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void tableCheck(Connection connection, Class clazz) {
        block4: {
            logger.trace("tableCheck -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName());
            String id = this.getConnectionIdentity(connection);
            if (!EXISTING_TABLES_CACHE.contains(id + CONNECTION_ID_SEPARATOR + clazz.getCanonicalName()) && !this.tableExists(connection, clazz)) {
                String auto = System.getProperty("DIRIGIBLE_PERSISTENCE_CREATE_TABLE_ON_USE");
                if (auto != null && !"true".equals(auto.toLowerCase(Locale.getDefault()))) {
                    throw new IllegalStateException("The parameter DIRIGIBLE_PERSISTENCE_CREATE_TABLE_ON_USE is off, but the table for the POJO has not been previousely created: " + clazz.getCanonicalName());
                }
                try {
                    this.tableCreate(connection, clazz);
                    EXISTING_TABLES_CACHE.add(id + CONNECTION_ID_SEPARATOR + clazz.getCanonicalName());
                }
                catch (Exception e) {
                    if (this.tableExists(connection, clazz)) break block4;
                    throw e;
                }
            }
        }
    }

    private String getConnectionIdentity(Connection connection) {
        try {
            String url = connection.getMetaData().getURL();
            return url.hashCode() + "";
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public void reset() {
        EXISTING_TABLES_CACHE.clear();
    }

    public void reset(Connection connection, Class<T> clazz) {
        String id = this.getConnectionIdentity(connection);
        EXISTING_TABLES_CACHE.remove(id + CONNECTION_ID_SEPARATOR + clazz.getCanonicalName());
    }

    public Object insert(Connection connection, T pojo) {
        logger.trace("tableCheck -> connection: " + connection.hashCode() + ", pojo: " + Serializer.serializePojo(pojo));
        this.tableCheck(connection, pojo.getClass());
        PersistenceTableModel tableModel = PersistenceFactory.createModel(pojo);
        PersistenceInsertProcessor<T> insertProcessor = new PersistenceInsertProcessor<T>(this.getEntityManagerInterceptor());
        return insertProcessor.insert(connection, tableModel, pojo);
    }

    public T find(Connection connection, Class<T> clazz, Object id) {
        logger.trace("find -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName() + ", id: " + id);
        this.tableCheck(connection, clazz);
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        PersistenceQueryProcessor<T> queryProcessor = new PersistenceQueryProcessor<T>(this.getEntityManagerInterceptor());
        return queryProcessor.find(connection, tableModel, clazz, id);
    }

    public T lock(Connection connection, Class<T> clazz, Object id) {
        logger.trace("lock -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName() + ", id: " + id);
        this.tableCheck(connection, clazz);
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        PersistenceQueryProcessor<T> queryProcessor = new PersistenceQueryProcessor<T>(this.getEntityManagerInterceptor());
        return queryProcessor.lock(connection, tableModel, clazz, id);
    }

    public List<T> findAll(Connection connection, Class<T> clazz) {
        logger.trace("findAll -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName());
        this.tableCheck(connection, clazz);
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        PersistenceQueryProcessor<T> queryProcessor = new PersistenceQueryProcessor<T>(this.getEntityManagerInterceptor());
        return queryProcessor.findAll(connection, tableModel, clazz);
    }

    public List<T> query(Connection connection, Class<T> clazz, String sql, List<Object> values) {
        logger.trace("query -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName() + ", sql: " + sql + ", values: " + Serializer.serializeListOfObjects(values));
        this.tableCheck(connection, clazz);
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        PersistenceQueryProcessor<T> queryProcessor = new PersistenceQueryProcessor<T>(this.getEntityManagerInterceptor());
        return queryProcessor.query(connection, tableModel, clazz, sql, values);
    }

    public List<T> query(Connection connection, Class<T> clazz, String sql, Object ... values) {
        return this.query(connection, clazz, sql, Arrays.asList(values));
    }

    public int execute(Connection connection, String sql, List<Object> values) {
        logger.trace("execute -> connection: " + connection.hashCode() + ", sql: " + sql + ", values: " + Serializer.serializeListOfObjects(values));
        PersistenceExecuteProcessor executeProcessor = new PersistenceExecuteProcessor(this.getEntityManagerInterceptor());
        return executeProcessor.execute(connection, sql, values);
    }

    public int execute(Connection connection, String sql, Object ... values) {
        return this.execute(connection, sql, Arrays.asList(values));
    }

    public int delete(Connection connection, Class<T> clazz, Object id) {
        logger.trace("delete -> connection: " + connection.hashCode() + ", class: " + clazz.getCanonicalName() + ", id: " + id);
        this.tableCheck(connection, clazz);
        PersistenceTableModel tableModel = PersistenceFactory.createModel(clazz);
        PersistenceDeleteProcessor<T> deleteProcessor = new PersistenceDeleteProcessor<T>(this.getEntityManagerInterceptor());
        return deleteProcessor.delete(connection, tableModel, clazz, id);
    }

    public int update(Connection connection, T pojo) {
        logger.trace("update -> connection: " + connection.hashCode() + ", pojo: " + Serializer.serializePojo(pojo));
        this.tableCheck(connection, pojo.getClass());
        PersistenceTableModel tableModel = PersistenceFactory.createModel(pojo);
        PersistenceUpdateProcessor<T> updateProcessor = new PersistenceUpdateProcessor<T>(this.getEntityManagerInterceptor());
        return updateProcessor.update(connection, tableModel, pojo);
    }

    public IEntityManagerInterceptor getEntityManagerInterceptor() {
        return this.entityManagerInterceptor;
    }

    public void setEntityManagerInterceptor(IEntityManagerInterceptor entityManagerInterceptor) {
        this.entityManagerInterceptor = entityManagerInterceptor;
    }
}

