/*
 * Copyright (c) 2017 SAP and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * SAP - initial API and implementation
 */

package org.eclipse.dirigible.database.persistence.model;

/**
 * The column element of the persistence model transport object.
 */
public class PersistenceTableColumnModel {

	private String field;

	private String name;

	private String type;

	private int length;

	private boolean nullable;

	private boolean primaryKey;

	private int precision;

	private int scale;

	private String generated;

	private boolean unique;

	private boolean identity;

	private String enumerated;

	/**
	 * The constructor from the fields.
	 *
	 * @param field
	 *            the field
	 * @param name
	 *            the name
	 * @param type
	 *            the type
	 * @param length
	 *            the length
	 * @param nullable
	 *            whether null values are allowed
	 * @param primaryKey
	 *            whether it is a primary key
	 * @param precision
	 *            the precision for floating point values
	 * @param scale
	 *            the scale for floating point values
	 * @param generated
	 *            whether it is a generated value
	 * @param unique
	 *            whether it is unique
	 * @param identity
	 *            whether it is identity
	 * @param enumerated
	 *            whether it is enumerated
	 */
	public PersistenceTableColumnModel(String field, String name, String type, int length, boolean nullable, boolean primaryKey, int precision,
			int scale, String generated, boolean unique, boolean identity, String enumerated) {
		this.field = field;
		this.name = name;
		this.type = type;
		this.length = length;
		this.nullable = nullable;
		this.primaryKey = primaryKey;
		this.precision = precision;
		this.scale = scale;
		this.generated = generated;
		this.unique = unique;
		this.identity = identity;
		this.enumerated = enumerated;
	}

	/**
	 * Getter for the field.
	 *
	 * @return the field
	 */
	public String getField() {
		return field;
	}

	/**
	 * Setter for the field.
	 *
	 * @param field
	 *            the field
	 */
	public void setField(String field) {
		this.field = field;
	}

	/**
	 * Getter for the name.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Setter for the name.
	 *
	 * @param name
	 *            the name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Getter for the type.
	 *
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Setter for the type.
	 *
	 * @param type
	 *            the type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Getter for the length.
	 *
	 * @return the length
	 */
	public int getLength() {
		return length;
	}

	/**
	 * Setter for the length.
	 *
	 * @param length
	 *            the length
	 */
	public void setLength(int length) {
		this.length = length;
	}

	/**
	 * Check for nullable.
	 *
	 * @return true if can be null
	 */
	public boolean isNullable() {
		return nullable;
	}

	/**
	 * Setter for the nullable.
	 *
	 * @param nullable
	 *            whether null values are allowed
	 */
	public void setNullable(boolean nullable) {
		this.nullable = nullable;
	}

	/**
	 * Check for primary key.
	 *
	 * @return true if primary key
	 */
	public boolean isPrimaryKey() {
		return primaryKey;
	}

	/**
	 * Setter for the primary key.
	 *
	 * @param primaryKey
	 *            whether it is a primary key
	 */
	public void setPrimaryKey(boolean primaryKey) {
		this.primaryKey = primaryKey;
	}

	/**
	 * Getter for the precision.
	 *
	 * @return the precision
	 */
	public int getPrecision() {
		return precision;
	}

	/**
	 * Setter for the precision.
	 *
	 * @param precision
	 *            the precision
	 */
	public void setPrecision(int precision) {
		this.precision = precision;
	}

	/**
	 * Getter for the scale.
	 *
	 * @return the scale
	 */
	public int getScale() {
		return scale;
	}

	/**
	 * Setter for the scale.
	 *
	 * @param scale
	 *            the scale
	 */
	public void setScale(int scale) {
		this.scale = scale;
	}

	/**
	 * Check whether it is generated value.
	 *
	 * @return true if generated
	 */
	public String getGenerated() {
		return generated;
	}

	/**
	 * Setter for the generated.
	 *
	 * @param generated
	 *            whether it is generated
	 */
	public void setGenerated(String generated) {
		this.generated = generated;
	}

	/**
	 * Check whether it is unique value.
	 *
	 * @return true if unique
	 */
	public boolean isUnique() {
		return unique;
	}

	/**
	 * Setter for the unique.
	 *
	 * @param unique
	 *            whether it is unique
	 */
	public void setUnique(boolean unique) {
		this.unique = unique;
	}

	/**
	 * Check whether it is identity value.
	 *
	 * @return true if identity
	 */
	public boolean isIdentity() {
		return identity;
	}

	/**
	 * Setter for the identity.
	 *
	 * @param identity
	 *            whether it is identity
	 */
	public void setIdentity(boolean identity) {
		this.identity = identity;
	}

	/**
	 * Returns the name of the enumerated type in case the column is of type enumerated or null otherwise.
	 *
	 * @return enumerated type name
	 */
	public String getEnumerated() {
		return enumerated;
	}

	/**
	 * Setter for the enumerated type name.
	 *
	 * @param enumerated
	 *            the new enumerated
	 */
	public void setEnumerated(String enumerated) {
		this.enumerated = enumerated;
	}

}
