/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.h2;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Database {
    private static final Logger logger = LoggerFactory.getLogger(H2Database.class);
    public static final String NAME = "h2";
    public static final String TYPE = "local";
    public static final String DIRIGIBLE_DATABASE_H2_ROOT_FOLDER = "DIRIGIBLE_DATABASE_H2_ROOT_FOLDER";
    public static final String DIRIGIBLE_DATABASE_H2_ROOT_FOLDER_DEFAULT = "DIRIGIBLE_DATABASE_H2_ROOT_FOLDER_DEFAULT";
    private static final Map<String, DataSource> DATASOURCES = Collections.synchronizedMap(new HashMap());

    public H2Database() throws SQLException {
        this(null);
    }

    public H2Database(String rootFolder) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing the embedded H2 datasource...");
        }
        this.initialize();
        if (logger.isDebugEnabled()) {
            logger.debug("Embedded H2 datasource initialized.");
        }
    }

    public void initialize() {
        Configuration.loadModuleConfig((String)"/dirigible-database-h2.properties");
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClass().getCanonicalName() + " module initialized.");
        }
    }

    public DataSource getDataSource(String name) throws SQLException {
        DataSource dataSource = DATASOURCES.get(name);
        if (dataSource != null) {
            return dataSource;
        }
        dataSource = this.createDataSource(name);
        return dataSource;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    protected DataSource createDataSource(String name) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating an embedded H2 datasource...");
        }
        Class<H2Database> clazz = H2Database.class;
        synchronized (H2Database.class) {
            try {
                String h2Root = this.prepareRootFolder(name);
                String databaseUrl = Configuration.get((String)"DIRIGIBLE_DATABASE_H2_URL");
                String databaseUsername = Configuration.get((String)"DIRIGIBLE_DATABASE_H2_USERNAME");
                String databasePassword = Configuration.get((String)"DIRIGIBLE_DATABASE_H2_PASSWORD");
                String databaseTimeout = Configuration.get((String)"DIRIGIBLE_DATABASE_DEFAULT_WAIT_TIMEOUT", (String)"180000");
                int timeout = 180000;
                try {
                    timeout = Integer.parseInt(databaseTimeout);
                }
                catch (NumberFormatException e) {
                    timeout = 180000;
                }
                if (databaseUrl != null && databaseUsername != null && databasePassword != null) {
                    HikariConfig config = new HikariConfig();
                    config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
                    config.setPoolName("H2DBHikariPool");
                    config.setConnectionTestQuery("VALUES 1");
                    config.addDataSourceProperty("URL", (Object)(databaseUrl + "/" + name));
                    config.addDataSourceProperty("user", (Object)databaseUsername);
                    config.addDataSourceProperty("password", (Object)databasePassword);
                    config.setMinimumIdle(5);
                    config.setMaximumPoolSize(50);
                    config.setConnectionTimeout((long)timeout);
                    config.setLeakDetectionThreshold((long)timeout);
                    config.setIdleTimeout(600000L);
                    config.setMaxLifetime(1800000L);
                    config.setAutoCommit(true);
                    HikariDataSource ds = new HikariDataSource(config);
                    if (logger.isWarnEnabled()) {
                        logger.warn("Embedded H2 at: {}", (Object)h2Root);
                    }
                    DATASOURCES.put(name, (DataSource)ds);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ds;
                }
                throw new SQLException("Invalid datasource parameters provided for H2 database");
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    private String prepareRootFolder(String name) throws IOException {
        Object rootFolder = "DefaultDB".equals(name) ? DIRIGIBLE_DATABASE_H2_ROOT_FOLDER_DEFAULT : DIRIGIBLE_DATABASE_H2_ROOT_FOLDER + name;
        String h2Root = Configuration.get((String)rootFolder, (String)name);
        File rootFile = new File(h2Root);
        File parentFile = rootFile.getCanonicalFile().getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException(MessageFormat.format("Creation of the root folder [{0}] of the embedded H2 database failed.", h2Root));
        }
        return h2Root;
    }

    public Map<String, DataSource> getDataSources() {
        HashMap<String, DataSource> datasources = new HashMap<String, DataSource>();
        datasources.putAll(DATASOURCES);
        return datasources;
    }
}

