/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.api.module.AbstractDirigibleModule;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.commons.config.StaticObjects;
import org.eclipse.dirigible.database.api.IDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseModule
extends AbstractDirigibleModule {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);
    private static final ServiceLoader<IDatabase> DATABASES = ServiceLoader.load(IDatabase.class);
    private static final String MODULE_NAME = "Database Module";

    public void configure() {
        Configuration.loadModuleConfig((String)"/dirigible-database.properties");
        boolean databaseProviderIsSelected = false;
        String databaseProvider = Configuration.get((String)"DIRIGIBLE_DATABASE_PROVIDER");
        String dataSourceName = Configuration.get((String)"DIRIGIBLE_DATABASE_DATASOURCE_NAME_DEFAULT", (String)"DefaultDB");
        String systemDataSourceName = Configuration.get((String)"DIRIGIBLE_DATABASE_DATASOURCE_NAME_SYSTEM", (String)"SystemDB");
        if (databaseProvider != null) {
            databaseProviderIsSelected = true;
        } else {
            databaseProvider = "local";
        }
        for (IDatabase next : DATABASES) {
            if (logger.isTraceEnabled()) {
                logger.trace(MessageFormat.format("Installing System Database Provider [{0}:{1}] ...", next.getType(), next.getName()));
            }
            if (next.getType().equals("local")) {
                this.bindSystemDatasource(next, systemDataSourceName);
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace(MessageFormat.format("Done installing System Database Provider [{0}:{1}].", next.getType(), next.getName()));
        }
        for (IDatabase next : DATABASES) {
            if (logger.isTraceEnabled()) {
                logger.trace(MessageFormat.format("Installing Database Provider [{0}:{1}] ...", next.getType(), next.getName()));
            }
            if (databaseProviderIsSelected && next.getType().equals(databaseProvider)) {
                this.bindDatasource(next, dataSourceName);
                break;
            }
            if (!databaseProviderIsSelected) {
                this.bindDatasource(next, dataSourceName);
                break;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace(MessageFormat.format("Done installing Database Provider [{0}:{1}].", next.getType(), next.getName()));
        }
    }

    private void bindSystemDatasource(IDatabase next, String dataSourceName) {
        block7: {
            if (logger.isTraceEnabled()) {
                logger.trace(MessageFormat.format("Binding System Database - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace(MessageFormat.format("Creating System Datasource - [{0}:{1}:{2}] ...", next.getType(), next.getName(), dataSourceName));
                }
                StaticObjects.set((String)"SYSTEM_DATASOURCE", (Object)next.getDataSource(dataSourceName));
                if (logger.isInfoEnabled()) {
                    logger.info(MessageFormat.format("Bound System Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(MessageFormat.format("Done creating System Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error(MessageFormat.format("Failed creating System Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName), (Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(MessageFormat.format("Done binding System Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
        }
    }

    private void bindDatasource(IDatabase next, String dataSourceName) {
        StaticObjects.set((String)"DATABASE", (Object)next);
        if (logger.isTraceEnabled()) {
            logger.trace(MessageFormat.format("Binding Database - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(MessageFormat.format("Creating Datasource - [{0}:{1}:{2}] ...", next.getType(), next.getName(), dataSourceName));
            }
            DataSource dataSource = next.getDataSource(dataSourceName);
            StaticObjects.set((String)"DATASOURCE", (Object)dataSource);
            if (!StaticObjects.exists((String)"SYSTEM_DATASOURCE")) {
                if (logger.isTraceEnabled()) {
                    logger.trace(MessageFormat.format("Reusing Datasource as a System Datasource - [{0}:{1}:{2}] ...", next.getType(), next.getName(), dataSourceName));
                }
                StaticObjects.set((String)"SYSTEM_DATASOURCE", (Object)dataSource);
                if (logger.isInfoEnabled()) {
                    logger.info(MessageFormat.format("Bound System Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(MessageFormat.format("Bound Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
            }
            if (logger.isTraceEnabled()) {
                logger.trace(MessageFormat.format("Done creating Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
            }
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Failed creating Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName), (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(MessageFormat.format("Done binding Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
        }
    }

    public String getName() {
        return MODULE_NAME;
    }

    public static DataSource getDataSource(String type, String datasource) {
        DataSource dataSource = null;
        for (IDatabase next : DATABASES) {
            if (!next.getType().equals(type)) continue;
            if (datasource == null) {
                dataSource = next.getDataSource();
                break;
            }
            dataSource = next.getDataSource(datasource);
            break;
        }
        return dataSource;
    }

    public static List<String> getDatabaseTypes() {
        HashSet<String> result = new HashSet<String>();
        for (IDatabase next : DATABASES) {
            result.add(next.getType());
        }
        return new ArrayList<String>(result);
    }

    public static Set<String> getDataSources(String type) {
        for (IDatabase next : DATABASES) {
            if (!next.getType().equals(type)) continue;
            return next.getDataSources().keySet();
        }
        return null;
    }

    public int getPriority() {
        return 20;
    }
}

