/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.databases.processor.format.AbstractResultSetWriter;

public class ResultSetJsonWriter
extends AbstractResultSetWriter<String> {
    private boolean limited = true;
    private boolean stringify = true;

    @Override
    public boolean isLimited() {
        return this.limited;
    }

    @Override
    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    @Override
    public boolean isStringified() {
        return this.stringify;
    }

    @Override
    public void setStringified(boolean stringify) {
        this.stringify = stringify;
    }

    @Override
    public String write(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JsonArray records = new JsonArray();
        int count = 0;
        while (resultSet.next()) {
            JsonObject record = new JsonObject();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String name = resultSetMetaData.getColumnName(i);
                Object value = resultSet.getObject(i);
                if (value == null && this.stringify) {
                    value = "[NULL]";
                }
                if (value != null && !ClassUtils.isPrimitiveOrWrapper(value.getClass()) && value.getClass() != String.class && !Date.class.isAssignableFrom(value.getClass()) && this.stringify) {
                    value = "[BINARY]";
                }
                record.add(name, GsonHelper.toJsonTree((Object)value));
            }
            records.add((JsonElement)record);
            if (!this.isLimited() || ++count <= this.getLimit()) continue;
            break;
        }
        return GsonHelper.toJson((Object)records);
    }
}

