/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api.wrappers;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(WrappedDataSource.class);
    private static final String DATABASE_NAME_HDB = "HDB";
    private String databaseName;
    private final DataSource originalDataSource;

    public WrappedDataSource(DataSource originalDataSource) {
        this.originalDataSource = originalDataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.originalDataSource.getConnection();
        if (this.databaseName == null) {
            this.databaseName = connection.getMetaData().getDatabaseProductName();
        }
        if (this.databaseName.equals(DATABASE_NAME_HDB)) {
            String userName = UserFacade.getName();
            if (logger.isDebugEnabled()) {
                logger.debug("Setting APPLICATIONUSER:{} for connection: {}", (Object)userName, (Object)connection);
            }
            connection.setClientInfo("APPLICATIONUSER", userName);
            if (logger.isDebugEnabled()) {
                logger.debug("Setting XS_APPLICATIONUSER:{} for connection: {}", (Object)userName, (Object)connection);
            }
            connection.setClientInfo("XS_APPLICATIONUSER", userName);
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.originalDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.originalDataSource.getLoginTimeout();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.originalDataSource.isWrapperFor(arg0);
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        this.originalDataSource.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        this.originalDataSource.setLoginTimeout(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.originalDataSource.unwrap(arg0);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

