/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.helpers;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.database.api.metadata.DatabaseMetadata;
import org.eclipse.dirigible.database.api.metadata.FunctionMetadata;
import org.eclipse.dirigible.database.api.metadata.ProcedureMetadata;
import org.eclipse.dirigible.database.api.metadata.SchemaMetadata;
import org.eclipse.dirigible.database.api.metadata.TableMetadata;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataHelper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetadataHelper.class);
    static final String SYSTEM_TABLE = "SYSTEM TABLE";
    static final String LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    static final String SYNONYM = "SYNONYM";
    static final String ALIAS = "ALIAS";
    static final String VIEW = "VIEW";
    static final String TABLE = "TABLE";
    static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "SYSTEM TABLE"};
    private static final String PRCNT = "%";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String EMPTY = "";
    private static final String PK = "PK";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String TYPE_INDEX = "TYPE";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String PAGES_INDEX = "PAGES";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final String PRECISION = "PRECISION";
    private static final String LENGTH = "LENGTH";
    private static final String SCALE = "SCALE";
    private static final String RADIX = "RADIX";
    private static final String NULLABLE = "NULLABLE";
    private static final String REMARKS = "REMARKS";

    private static ISqlDialect getDialect(Connection connection) {
        return SqlFactory.deriveDialect((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SchemaMetadata> listSchemas(Connection connection, String catalogName, Filter<String> schemaNameFilter, Filter<String> nameFilter) throws SQLException {
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<SchemaMetadata> result = new ArrayList<SchemaMetadata>();
        try (ResultSet rs = null;){
            DatabaseMetaData dmd;
            if (sqlDialect.isSchemaFilterSupported()) {
                try {
                    rs = connection.createStatement().executeQuery(sqlDialect.getSchemaFilterScript());
                }
                catch (Exception e) {
                    if (rs != null) {
                        rs.close();
                    }
                    DatabaseMetaData dmd2 = connection.getMetaData();
                    rs = dmd2.getSchemas(catalogName, null);
                }
            } else if (sqlDialect.isCatalogForSchema()) {
                dmd = connection.getMetaData();
                rs = dmd.getCatalogs();
            } else {
                dmd = connection.getMetaData();
                rs = dmd.getSchemas(catalogName, null);
            }
            if (rs != null) {
                while (rs.next()) {
                    String schemeName = rs.getString(1);
                    if (schemaNameFilter != null && !schemaNameFilter.accepts(schemeName)) continue;
                    result.add(new SchemaMetadata(schemeName, connection, catalogName, nameFilter));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TableMetadata> listTables(Connection connection, String catalogName, String schemeName, Filter<String> tableNameFilter) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<TableMetadata> result = new ArrayList<TableMetadata>();
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getTables(schemeName, null, PRCNT, TABLE_TYPES) : dmd.getTables(catalogName, schemeName, PRCNT, TABLE_TYPES);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String tableRemarks = rs.getString(REMARKS);
                if (tableNameFilter != null && !tableNameFilter.accepts(tableName)) continue;
                result.add(new TableMetadata(tableName, tableType, tableRemarks, connection, catalogName, schemeName, false));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProcedureMetadata> listProcedures(Connection connection, String catalogName, String schemeName, Filter<String> procedureNameFilter) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<ProcedureMetadata> result = new ArrayList<ProcedureMetadata>();
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getProcedures(schemeName, null, PRCNT) : dmd.getProcedures(catalogName, schemeName, PRCNT);
            while (rs.next()) {
                String procedureName = rs.getString("PROCEDURE_NAME");
                String procedureType = rs.getString("PROCEDURE_TYPE");
                String procedureRemarks = rs.getString(REMARKS);
                if (procedureNameFilter != null && !procedureNameFilter.accepts(procedureName)) continue;
                result.add(new ProcedureMetadata(procedureName, procedureType, procedureRemarks, connection, catalogName, schemeName, false));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FunctionMetadata> listFunctions(Connection connection, String catalogName, String schemeName, Filter<String> functionNameFilter) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<FunctionMetadata> result = new ArrayList<FunctionMetadata>();
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getFunctions(schemeName, null, PRCNT) : dmd.getFunctions(catalogName, schemeName, PRCNT);
            while (rs.next()) {
                String functionName = rs.getString("FUNCTION_NAME");
                String functionType = rs.getString("FUNCTION_TYPE");
                String functionRemarks = rs.getString(REMARKS);
                if (functionNameFilter != null && !functionNameFilter.accepts(functionName)) continue;
                result.add(new FunctionMetadata(functionName, functionType, functionRemarks, connection, catalogName, schemeName, false));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMetadata describeTable(Connection connection, String catalogName, String schemeName, String tableName) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getTables(schemeName, null, DatabaseMetadataHelper.normalizeTableName(tableName), TABLE_TYPES) : dmd.getTables(catalogName, schemeName, DatabaseMetadataHelper.normalizeTableName(tableName), TABLE_TYPES);
            if (rs.next()) {
                String tableType = rs.getString("TABLE_TYPE");
                String tableRemarks = rs.getString(REMARKS);
                TableMetadata tableMetadata = new TableMetadata(tableName, tableType, tableRemarks, connection, catalogName, schemeName, true);
                return tableMetadata;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcedureMetadata describeProcedure(Connection connection, String catalogName, String schemeName, String procedureName) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getProcedures(schemeName, null, DatabaseMetadataHelper.normalizeTableName(procedureName)) : dmd.getProcedures(catalogName, schemeName, DatabaseMetadataHelper.normalizeTableName(procedureName));
            if (rs.next()) {
                String procedureType = rs.getString("PROCEDURE_TYPE");
                String procedureRemarks = rs.getString(REMARKS);
                ProcedureMetadata procedureMetadata = new ProcedureMetadata(procedureName, procedureType, procedureRemarks, connection, catalogName, schemeName, true);
                return procedureMetadata;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FunctionMetadata describeFunction(Connection connection, String catalogName, String schemeName, String functionName) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getFunctions(schemeName, null, DatabaseMetadataHelper.normalizeTableName(functionName)) : dmd.getFunctions(catalogName, schemeName, DatabaseMetadataHelper.normalizeTableName(functionName));
            if (rs.next()) {
                String functionType = rs.getString("FUNCTION_TYPE");
                String functionRemarks = rs.getString(REMARKS);
                FunctionMetadata functionMetadata = new FunctionMetadata(functionName, functionType, functionRemarks, connection, catalogName, schemeName, true);
                return functionMetadata;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateTableDefinition(Connection connection, String catalogName, String schemaName, String tableName, ColumnsIteratorCallback columnsIteratorCallback, IndicesIteratorCallback indicesIteratorCallback) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet columns = dmd.getColumns(catalogName, schemaName, DatabaseMetadataHelper.normalizeTableName(tableName), null);
        if (columns == null) {
            throw new SQLException("DatabaseMetaData.getColumns returns null");
        }
        ResultSet pks = dmd.getPrimaryKeys(catalogName, schemaName, DatabaseMetadataHelper.normalizeTableName(tableName));
        if (pks == null) {
            throw new SQLException("DatabaseMetaData.getPrimaryKeys returns null");
        }
        ResultSet indexes = dmd.getIndexInfo(catalogName, schemaName, DatabaseMetadataHelper.normalizeTableName(tableName), false, false);
        if (indexes == null) {
            throw new SQLException("DatabaseMetaData.getIndexInfo returns null");
        }
        try {
            ArrayList<String> pkList = new ArrayList<String>();
            while (pks.next()) {
                String pkName = pks.getString(COLUMN_NAME);
                pkList.add(pkName);
            }
            while (columns.next()) {
                if (columnsIteratorCallback == null) continue;
                String cname = columns.getString(COLUMN_NAME);
                columnsIteratorCallback.onColumn(cname, columns.getString(TYPE_NAME), EMPTY + columns.getInt(COLUMN_SIZE), columns.getBoolean(IS_NULLABLE), pkList.contains(cname));
            }
            while (indexes.next()) {
                if (indicesIteratorCallback == null) continue;
                indicesIteratorCallback.onIndex(indexes.getString(INDEX_NAME), indexes.getString(TYPE_INDEX), indexes.getString(COLUMN_NAME), indexes.getBoolean(NON_UNIQUE), indexes.getString(INDEX_QUALIFIER), EMPTY + indexes.getShort(ORDINAL_POSITION), indexes.getString(ASC_OR_DESC), EMPTY + indexes.getInt(CARDINALITY), EMPTY + indexes.getInt(PAGES_INDEX), indexes.getString(FILTER_CONDITION));
            }
        }
        finally {
            columns.close();
            indexes.close();
            pks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateProcedureDefinition(Connection connection, String catalogName, String schemaName, String procedureName, ProcedureColumnsIteratorCallback procedureColumnsIteratorCallback) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet columns = dmd.getProcedureColumns(catalogName, schemaName, DatabaseMetadataHelper.normalizeTableName(procedureName), null);
        if (columns == null) {
            throw new SQLException("DatabaseMetaData.getProcedureColumns returns null");
        }
        try {
            while (columns.next()) {
                if (procedureColumnsIteratorCallback == null) continue;
                String cname = columns.getString(COLUMN_NAME);
                procedureColumnsIteratorCallback.onProcedureColumn(cname, columns.getInt(COLUMN_TYPE), columns.getString(TYPE_NAME), columns.getInt(PRECISION), columns.getInt(LENGTH), columns.getInt(SCALE), columns.getInt(RADIX), columns.getBoolean(NULLABLE), columns.getString(REMARKS));
            }
        }
        finally {
            columns.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateFunctionDefinition(Connection connection, String catalogName, String schemaName, String functionName, FunctionColumnsIteratorCallback functionColumnsIteratorCallback) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet columns = dmd.getFunctionColumns(catalogName, schemaName, DatabaseMetadataHelper.normalizeTableName(functionName), null);
        if (columns == null) {
            throw new SQLException("DatabaseMetaData.getFunctionColumns returns null");
        }
        try {
            while (columns.next()) {
                if (functionColumnsIteratorCallback == null) continue;
                String cname = columns.getString(COLUMN_NAME);
                functionColumnsIteratorCallback.onFunctionColumn(cname, columns.getInt(COLUMN_TYPE), columns.getString(TYPE_NAME), columns.getInt(PRECISION), columns.getInt(LENGTH), columns.getInt(SCALE), columns.getInt(RADIX), columns.getBoolean(NULLABLE), columns.getString(REMARKS));
            }
        }
        finally {
            columns.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetadataAsJson(DataSource dataSource) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            DatabaseMetadata database = new DatabaseMetadata(connection, null, null, null);
            String string = json = GsonHelper.GSON.toJson((Object)database);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableMetadataAsJson(DataSource dataSource, String schema, String table) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            TableMetadata tableMetadata = DatabaseMetadataHelper.describeTable(connection, null, schema, table);
            String string = json = GsonHelper.GSON.toJson((Object)tableMetadata);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcedureMetadataAsJson(DataSource dataSource, String schema, String procedure) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            ProcedureMetadata procedureMetadata = DatabaseMetadataHelper.describeProcedure(connection, null, schema, procedure);
            String string = json = GsonHelper.GSON.toJson((Object)procedureMetadata);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFunctionMetadataAsJson(DataSource dataSource, String schema, String function) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            FunctionMetadata functionMetadata = DatabaseMetadataHelper.describeFunction(connection, null, schema, function);
            String string = json = GsonHelper.GSON.toJson((Object)functionMetadata);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProductName(DataSource dataSource) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetadata database = new DatabaseMetadata(connection, null, null, null);
            String string = database.getDatabaseProductName();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String normalizeTableName(String table) {
        if (table != null && table.startsWith("\"") && table.endsWith("\"")) {
            table = table.substring(1, table.length() - 1);
        }
        return table;
    }

    public static interface Filter<T> {
        public boolean accepts(T var1);
    }

    public static interface ColumnsIteratorCallback {
        public void onColumn(String var1, String var2, String var3, boolean var4, boolean var5);
    }

    public static interface IndicesIteratorCallback {
        public void onIndex(String var1, String var2, String var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10);
    }

    public static interface ProcedureColumnsIteratorCallback {
        public void onProcedureColumn(String var1, int var2, String var3, int var4, int var5, int var6, int var7, boolean var8, String var9);
    }

    public static interface FunctionColumnsIteratorCallback {
        public void onFunctionColumn(String var1, int var2, String var3, int var4, int var5, int var6, int var7, boolean var8, String var9);
    }
}

