/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.dirigible.databases.processor.format.ColumnDescriptor;
import org.eclipse.dirigible.databases.processor.format.ResultSetMonospacedWriter;
import org.eclipse.dirigible.databases.processor.format.RowFormatter;

public class StringRowFormatter
implements RowFormatter<String> {
    private static final String VALUE_NULL = "[NULL]";
    private static final String VALUE_BINARY = "[BINARY]";
    static final int[] BINARY_TYPES = new int[]{2003, -2, -7, -7, 2004, 2005, 70, 2001, 2000, -4, 2011, 0, 1111, 2006, 2009, 2002, -3};

    @Override
    public String write(List<ColumnDescriptor> columnDescriptors, ResultSetMetaData resultSetMetaData, ResultSet resultSet) throws SQLException {
        StringBuilder buff = new StringBuilder();
        buff.append("|");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            String value = null;
            if (columnDescriptor.getSqlType() == Integer.MIN_VALUE) {
                value = "";
            } else {
                value = this.isBinaryType(columnDescriptor.getSqlType()) ? VALUE_BINARY : resultSet.getString(columnDescriptor.getLabel());
                if (value == null) {
                    value = VALUE_NULL;
                }
                if (!VALUE_BINARY.equals(value) || !VALUE_NULL.equals(value)) {
                    int delta = value.length() - columnDescriptor.getDisplaySize();
                    if (delta > 0) {
                        if ((value = value.substring(0, columnDescriptor.getDisplaySize())).length() > 3) {
                            value = value.substring(0, value.length() - 3) + "...";
                        }
                    } else if (delta < 0) {
                        value = String.format("%-" + columnDescriptor.getDisplaySize() + "s", value);
                    }
                }
            }
            buff.append(value);
            buff.append("|");
        }
        buff.append(ResultSetMonospacedWriter.NEWLINE_CHARACTER);
        return buff.toString();
    }

    boolean isBinaryType(int columnType) {
        for (int c : BINARY_TYPES) {
            if (columnType != c) continue;
            return true;
        }
        return false;
    }
}

