/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.databases.processor.format.ColumnDescriptor;
import org.eclipse.dirigible.databases.processor.format.HeaderFormatter;
import org.eclipse.dirigible.databases.processor.format.ResultSetWriter;
import org.eclipse.dirigible.databases.processor.format.RowFormatter;
import org.eclipse.dirigible.databases.processor.format.StringHeaderFormatter;
import org.eclipse.dirigible.databases.processor.format.StringRowFormatter;

public class ResultSetMonospacedWriter
implements ResultSetWriter<String> {
    private static final int LIMIT = 100;
    private static final String EMPTY_RESULT_SET = "Empty result set";
    public static final String DELIMITER = "|";
    public static final String NEWLINE_CHARACTER = System.getProperty("line.separator");
    private HeaderFormatter<?> headerFormat = new StringHeaderFormatter();
    private RowFormatter<?> rowFormat = new StringRowFormatter();
    private boolean limited = true;

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    @Override
    public String write(ResultSet resultSet) throws SQLException {
        StringBuilder buffer = new StringBuilder();
        ArrayList<ColumnDescriptor> columnHeaderDescriptors = new ArrayList<ColumnDescriptor>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int count = 0;
        while (resultSet.next()) {
            resultSetMetaData = resultSet.getMetaData();
            List<String> headersForRow = this.getHeader(resultSetMetaData);
            for (String headerForRow : headersForRow) {
                ColumnDescriptor columnDescriptor = new ColumnDescriptor();
                columnDescriptor.setName(headerForRow);
                int columnIndex = this.getColumnIndexByName(columnDescriptor.getName(), resultSetMetaData);
                columnDescriptor.setLabel(resultSetMetaData.getColumnLabel(columnIndex));
                if (columnDescriptor.getLabel() == null) {
                    columnDescriptor.setLabel(columnDescriptor.getName());
                }
                columnDescriptor.setSqlType(resultSetMetaData.getColumnType(columnIndex));
                int displaySize = resultSetMetaData.getColumnDisplaySize(columnIndex);
                if (displaySize > 256) {
                    displaySize = 256;
                }
                columnDescriptor.setDisplaySize(displaySize);
                if (columnDescriptor.getDisplaySize() < columnDescriptor.getName().length()) {
                    columnDescriptor.setDisplaySize(columnDescriptor.getName().length());
                }
                if (columnHeaderDescriptors.contains(columnDescriptor)) continue;
                columnHeaderDescriptors.add(columnDescriptor);
            }
            buffer.append(this.rowFormat.write(columnHeaderDescriptors, resultSetMetaData, resultSet));
            if (!this.isLimited() || ++count <= 100) continue;
            buffer.append("...");
            break;
        }
        if (columnHeaderDescriptors.size() > 0) {
            String headers = (String)this.headerFormat.write(columnHeaderDescriptors);
            buffer.insert(0, headers);
        } else {
            buffer.append(EMPTY_RESULT_SET);
        }
        return buffer.toString();
    }

    int getColumnIndexByName(String columnName, ResultSetMetaData metadata) throws SQLException {
        for (int i = 1; i < metadata.getColumnCount() + 1; ++i) {
            if (!columnName.equals(metadata.getColumnName(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    List<String> getHeader(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> columnHeaderLabels = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnHeaderLabel = resultSetMetaData.getColumnLabel(i);
            columnHeaderLabels.add(columnHeaderLabel);
        }
        return columnHeaderLabels;
    }

    public HeaderFormatter<?> getHeaderFormat() {
        return this.headerFormat;
    }

    public void setHeaderFormat(HeaderFormatter<?> headerFormat) {
        this.headerFormat = headerFormat;
    }

    public RowFormatter<?> getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(RowFormatter<?> rowFormat) {
        this.rowFormat = rowFormat;
    }
}

