/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.databases.processor.format.ResultSetWriter;

public class ResultSetJsonWriter
implements ResultSetWriter<String> {
    private static final int LIMIT = 100;
    private boolean limited = true;

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    @Override
    public String write(ResultSet resultSet) throws SQLException {
        StringBuilder tableSb = new StringBuilder();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JsonArray records = new JsonArray();
        int count = 0;
        while (resultSet.next()) {
            JsonObject record = new JsonObject();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String name = resultSetMetaData.getColumnName(i);
                Object value = resultSet.getObject(i);
                record.add(name, GsonHelper.GSON.toJsonTree(value));
            }
            records.add((JsonElement)record);
            if (!this.isLimited() || ++count <= 100) continue;
            tableSb.append("...");
            break;
        }
        return GsonHelper.GSON.toJson((JsonElement)records);
    }
}

