/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.helpers;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.database.api.metadata.DatabaseMetadata;
import org.eclipse.dirigible.database.api.metadata.SchemaMetadata;
import org.eclipse.dirigible.database.api.metadata.TableMetadata;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataHelper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetadataHelper.class);
    static final String SYSTEM_TABLE = "SYSTEM TABLE";
    static final String LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    static final String SYNONYM = "SYNONYM";
    static final String ALIAS = "ALIAS";
    static final String VIEW = "VIEW";
    static final String TABLE = "TABLE";
    static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "SYSTEM TABLE"};
    private static final String PRCNT = "%";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String EMPTY = "";
    private static final String PK = "PK";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String TYPE_INDEX = "TYPE";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String PAGES_INDEX = "PAGES";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";

    private static ISqlDialect getDialect(Connection connection) {
        return SqlFactory.deriveDialect((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SchemaMetadata> listSchemas(Connection connection, String catalogName, Filter<String> schemaNameFilter, Filter<String> tableNameFilter) throws SQLException {
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<SchemaMetadata> result = new ArrayList<SchemaMetadata>();
        try (ResultSet rs = null;){
            DatabaseMetaData dmd;
            if (sqlDialect.isSchemaFilterSupported()) {
                try {
                    rs = connection.createStatement().executeQuery(sqlDialect.getSchemaFilterScript());
                }
                catch (Exception e) {
                    if (rs != null) {
                        rs.close();
                    }
                    DatabaseMetaData dmd2 = connection.getMetaData();
                    rs = dmd2.getSchemas(catalogName, null);
                }
            } else if (sqlDialect.isCatalogForSchema()) {
                dmd = connection.getMetaData();
                rs = dmd.getCatalogs();
            } else {
                dmd = connection.getMetaData();
                rs = dmd.getSchemas(catalogName, null);
            }
            if (rs != null) {
                while (rs.next()) {
                    String schemeName = rs.getString(1);
                    if (schemaNameFilter != null && !schemaNameFilter.accepts(schemeName)) continue;
                    result.add(new SchemaMetadata(schemeName, connection, catalogName, tableNameFilter));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TableMetadata> listTables(Connection connection, String catalogName, String schemeName, Filter<String> tableNameFilter) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        ArrayList<TableMetadata> result = new ArrayList<TableMetadata>();
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getTables(schemeName, null, PRCNT, TABLE_TYPES) : dmd.getTables(catalogName, schemeName, PRCNT, TABLE_TYPES);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String tableRemarks = rs.getString("REMARKS");
                if (tableNameFilter != null && !tableNameFilter.accepts(tableName)) continue;
                result.add(new TableMetadata(tableName, tableType, tableRemarks, connection, catalogName, schemeName, false));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMetadata describeTable(Connection connection, String catalogName, String schemeName, String tableName) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ISqlDialect sqlDialect = DatabaseMetadataHelper.getDialect(connection);
        try (ResultSet rs = null;){
            rs = sqlDialect.isCatalogForSchema() ? dmd.getTables(schemeName, null, tableName, TABLE_TYPES) : dmd.getTables(catalogName, schemeName, tableName, TABLE_TYPES);
            if (rs.next()) {
                String tableType = rs.getString("TABLE_TYPE");
                String tableRemarks = rs.getString("REMARKS");
                TableMetadata tableMetadata = new TableMetadata(tableName, tableType, tableRemarks, connection, catalogName, schemeName, true);
                return tableMetadata;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateTableDefinition(Connection connection, String catalogName, String schemaName, String tableName, ColumnsIteratorCallback columnsIteratorCallback, IndicesIteratorCallback indicesIteratorCallback) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet columns = dmd.getColumns(catalogName, schemaName, tableName, null);
        if (columns == null) {
            throw new SQLException("DatabaseMetaData.getColumns returns null");
        }
        ResultSet pks = dmd.getPrimaryKeys(catalogName, schemaName, tableName);
        if (pks == null) {
            throw new SQLException("DatabaseMetaData.getPrimaryKeys returns null");
        }
        ResultSet indexes = dmd.getIndexInfo(catalogName, schemaName, tableName, false, false);
        if (indexes == null) {
            throw new SQLException("DatabaseMetaData.getIndexInfo returns null");
        }
        try {
            ArrayList<String> pkList = new ArrayList<String>();
            while (pks.next()) {
                String pkName = pks.getString(COLUMN_NAME);
                pkList.add(pkName);
            }
            while (columns.next()) {
                if (columnsIteratorCallback == null) continue;
                String cname = columns.getString(COLUMN_NAME);
                columnsIteratorCallback.onColumn(cname, columns.getString(TYPE_NAME), columns.getInt(COLUMN_SIZE) + EMPTY, columns.getString(IS_NULLABLE), pkList.contains(cname) ? PK : EMPTY);
            }
            while (indexes.next()) {
                if (indicesIteratorCallback == null) continue;
                indicesIteratorCallback.onIndex(indexes.getString(INDEX_NAME), indexes.getString(TYPE_INDEX), indexes.getString(COLUMN_NAME), indexes.getString(NON_UNIQUE), indexes.getString(INDEX_QUALIFIER), indexes.getShort(ORDINAL_POSITION) + EMPTY, indexes.getString(ASC_OR_DESC), indexes.getInt(CARDINALITY) + EMPTY, indexes.getInt(PAGES_INDEX) + EMPTY, indexes.getString(FILTER_CONDITION));
            }
        }
        finally {
            columns.close();
            indexes.close();
            pks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetadataAsJson(DataSource dataSource) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            DatabaseMetadata database = new DatabaseMetadata(connection, null, null, null);
            String string = json = GsonHelper.GSON.toJson((Object)database);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableMetadataAsJson(DataSource dataSource, String schema, String table) throws SQLException {
        Connection connection = null;
        try {
            String json;
            connection = dataSource.getConnection();
            TableMetadata tableMetadata = DatabaseMetadataHelper.describeTable(connection, null, schema, table);
            String string = json = GsonHelper.GSON.toJson((Object)tableMetadata);
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProductName(DataSource dataSource) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetadata database = new DatabaseMetadata(connection, null, null, null);
            String string = database.getDatabaseProductName();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static interface IndicesIteratorCallback {
        public void onIndex(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10);
    }

    public static interface ColumnsIteratorCallback {
        public void onColumn(String var1, String var2, String var3, String var4, String var5);
    }

    public static interface Filter<T> {
        public boolean accepts(T var1);
    }
}

