/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.api.module.AbstractDirigibleModule;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.api.IDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseModule
extends AbstractDirigibleModule {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);
    private static final ServiceLoader<IDatabase> DATABASES = ServiceLoader.load(IDatabase.class);
    private static final String MODULE_NAME = "Database Module";

    protected void configure() {
        Configuration.load((String)"/dirigible-database.properties");
        boolean databaseProviderIsSelected = false;
        String databaseProvider = Configuration.get((String)"DIRIGIBLE_DATABASE_PROVIDER");
        String dataSourceName = Configuration.get((String)"DIRIGIBLE_DATABASE_DATASOURCE_NAME_DEFAULT", (String)"DefaultDB");
        if (databaseProvider != null) {
            databaseProviderIsSelected = true;
        } else {
            databaseProvider = "local";
        }
        for (IDatabase next : DATABASES) {
            logger.trace(MessageFormat.format("Installing Database Provider [{0}:{1}] ...", next.getType(), next.getName()));
            if (databaseProviderIsSelected && next.getType().equals(databaseProvider)) {
                this.bindDatasource(next, dataSourceName);
            } else if (!databaseProviderIsSelected) {
                this.bindDatasource(next, dataSourceName);
                break;
            }
            logger.trace(MessageFormat.format("Done installing Database Provider [{0}:{1}].", next.getType(), next.getName()));
        }
    }

    private void bindDatasource(IDatabase next, String dataSourceName) {
        this.bind(IDatabase.class).toInstance((Object)next);
        logger.trace(MessageFormat.format("Binding Database - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
        try {
            logger.trace(MessageFormat.format("Creating Datasource - [{0}:{1}:{2}] ...", next.getType(), next.getName(), dataSourceName));
            this.bind(DataSource.class).toInstance((Object)next.getDataSource(dataSourceName));
            logger.info(MessageFormat.format("Bound Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
            logger.trace(MessageFormat.format("Done creating Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Failed creating Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName), (Throwable)e);
        }
        logger.trace(MessageFormat.format("Done binding Datasource - [{0}:{1}:{2}].", next.getType(), next.getName(), dataSourceName));
    }

    public String getName() {
        return MODULE_NAME;
    }

    public static DataSource getDataSource(String type, String datasource) {
        DataSource dataSource = null;
        for (IDatabase next : DATABASES) {
            if (!next.getType().equals(type)) continue;
            if (datasource == null) {
                dataSource = next.getDataSource();
                break;
            }
            dataSource = next.getDataSource(datasource);
            break;
        }
        return dataSource;
    }

    public static List<String> getDatabaseTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (IDatabase next : DATABASES) {
            result.add(next.getType());
        }
        return result;
    }

    public static Set<String> getDataSources(String type) {
        for (IDatabase next : DATABASES) {
            if (!next.getType().equals(type)) continue;
            return next.getDataSources().keySet();
        }
        return null;
    }
}

