/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.runtime;

import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;

class TckExecutionListener
implements TestExecutionListener {
    private Monitor monitor;

    TckExecutionListener(Monitor monitor) {
        this.monitor = monitor;
    }

    public void executionStarted(TestIdentifier identifier) {
        if (identifier.getSource().isPresent() && identifier.getSource().get() instanceof MethodSource) {
            this.monitor.newLine().message("Started: " + identifier.getDisplayName());
        }
    }

    public void executionFinished(TestIdentifier identifier, TestExecutionResult result) {
        if (identifier.getSource().isPresent() && identifier.getSource().get() instanceof MethodSource) {
            String displayName = identifier.getDisplayName();
            if (displayName.contains(":")) {
                displayName = displayName.substring(0, displayName.lastIndexOf(":"));
            }
            this.monitor.message(String.format("%s: %s%n", result.getStatus(), displayName));
        }
    }
}

