/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.runtime;

import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class ConsoleResultWriter {
    private Monitor monitor;

    public ConsoleResultWriter(Monitor monitor) {
        this.monitor = monitor;
    }

    public void output(TestExecutionSummary result) {
        this.monitor.message("Passed tests: " + result.getTestsSucceededCount());
        this.monitor.message("Failed tests: " + result.getTestsFailedCount());
        if (!result.getFailures().isEmpty()) {
            this.monitor.enableError().message("Failures:");
            result.getFailures().stream().filter(f -> f.getTestIdentifier().getSource().isPresent() && f.getTestIdentifier().getSource().get() instanceof MethodSource).forEach(f -> {
                MethodSource method = (MethodSource)f.getTestIdentifier().getSource().get();
                this.monitor.message(String.format("\n   %c %s.%s\n", Character.valueOf('\u25a0'), method.getClassName(), method.getMethodName()));
                this.monitor.message("     [" + f.getTestIdentifier().getDisplayName() + "]");
                this.monitor.message("     " + f.getException().getMessage() + "\n");
            });
            this.monitor.resetMode();
        } else {
            this.monitor.enableSuccess().message("\ud83c\udf89\ud83d\ude03\ud83d\ude80All tests passed").resetMode();
        }
    }
}

