/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.runtime.TckExecutionListener;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TckRuntime {
    private static final String TEST_POSTFIX = ".*Test";
    private final List<String> packages = new ArrayList<String>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private Monitor monitor;

    private TckRuntime() {
    }

    public TestExecutionSummary execute() {
        this.properties.forEach(System::setProperty);
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{TEST_POSTFIX})}).selectors(this.packages.stream().map(DiscoverySelectors::selectPackage).toList()).build();
        Launcher launcher = LauncherFactory.create();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{new TckExecutionListener(this.monitor)});
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
        launcher.discover(request);
        launcher.execute(request, new TestExecutionListener[0]);
        this.properties.forEach((k, v) -> System.clearProperty(k));
        return summaryListener.getSummary();
    }

    public static class Builder {
        private final TckRuntime launcher = new TckRuntime();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder property(String key, String value) {
            this.launcher.properties.put(key, value);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.launcher.properties.putAll(properties);
            return this;
        }

        public Builder addPackage(String pkg) {
            this.launcher.packages.add(pkg);
            return this;
        }

        public TckRuntime build() {
            return this.launcher;
        }

        public Builder monitor(Monitor monitor) {
            this.launcher.monitor = monitor;
            return this;
        }
    }
}

