/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock.tp;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ProviderTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.TransferProcessListener;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.ProviderTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.TransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.mock.tp.AbstractTransferProcessMock;

public class ProviderTransferProcessMockImpl
extends AbstractTransferProcessMock
implements ProviderTransferProcessMock,
TransferProcessListener {
    private final ProviderTransferProcessManager manager;
    private final String baseAddress;

    public ProviderTransferProcessMockImpl(ProviderTransferProcessManager manager, Executor executor, String baseAddress) {
        super(executor);
        this.manager = manager;
        this.baseAddress = baseAddress;
        manager.registerListener((TransferProcessListener)this);
    }

    @Override
    public void verify() {
        super.verify();
        this.manager.deregisterListener((TransferProcessListener)this);
    }

    public void recordTransferRequestedAction(TransferProcessMock.Action action) {
        this.recordAction(TransferProcess.State.REQUESTED, action);
    }

    @Override
    protected void recordAction(TransferProcess.State state, TransferProcessMock.Action action) {
        this.actions.computeIfAbsent(state, k -> new ConcurrentLinkedQueue()).add(action);
    }

    public void requested(TransferProcess transferProcess) {
        TransferProcessMock.Action action = (TransferProcessMock.Action)this.actions.getOrDefault(TransferProcess.State.REQUESTED, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)transferProcess));
    }
}

