/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock.tp;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.TransferProcessListener;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.TransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.mockito.internal.util.StringUtil;

public abstract class AbstractTransferProcessMock
implements TransferProcessMock,
TransferProcessListener {
    protected static final Queue<TransferProcessMock.Action> EMPTY_QUEUE = new ArrayDeque<TransferProcessMock.Action>();
    protected Executor executor;
    protected Map<TransferProcess.State, Queue<TransferProcessMock.Action>> actions = new ConcurrentHashMap<TransferProcess.State, Queue<TransferProcessMock.Action>>();

    public AbstractTransferProcessMock(Executor executor) {
        this.executor = executor;
    }

    public void verify() {
        List actions;
        if (!this.actions.isEmpty() && !(actions = this.actions.entrySet().stream().filter(e -> !((Queue)e.getValue()).isEmpty()).map(e -> ((TransferProcess.State)e.getKey()).toString()).collect(Collectors.toList())).isEmpty()) {
            throw new AssertionError((Object)String.format("Request actions not executed.\n Actions: %s", StringUtil.join((String)", ", actions)));
        }
    }

    public boolean completed() {
        return this.actions.isEmpty();
    }

    public void reset() {
        this.actions.clear();
    }

    protected void recordAction(TransferProcess.State state, TransferProcessMock.Action action) {
        this.actions.computeIfAbsent(state, k -> new ConcurrentLinkedQueue()).add(action);
    }

    public void started(TransferProcess transferProcess) {
        TransferProcessMock.Action action = this.actions.getOrDefault(TransferProcess.State.STARTED, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)transferProcess));
    }
}

