/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock;

import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.eclipse.dataspacetck.dsp.system.api.connector.ConsumerNegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.connector.NegotiationListener;
import org.eclipse.dataspacetck.dsp.system.api.mock.ConsumerNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.NegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.mock.AbstractNegotiationMock;

public class ConsumerNegotiationMockImpl
extends AbstractNegotiationMock
implements ConsumerNegotiationMock,
NegotiationListener {
    private final ConsumerNegotiationManager manager;
    private final String baseAddress;

    public ConsumerNegotiationMockImpl(ConsumerNegotiationManager manager, Executor executor, String baseAddress) {
        super(executor);
        this.manager = manager;
        this.baseAddress = baseAddress;
        manager.registerListener((NegotiationListener)this);
    }

    public void recordInitializedAction(BiConsumer<String, ContractNegotiation> action) {
        this.recordAction(ContractNegotiation.State.INITIALIZED, cn -> action.accept(this.baseAddress, (ContractNegotiation)cn));
    }

    public void recordRequestAction(BiConsumer<String, ContractNegotiation> action) {
        this.recordAction(ContractNegotiation.State.REQUESTED, cn -> action.accept(this.baseAddress, (ContractNegotiation)cn));
    }

    public void recordOfferedAction(BiConsumer<String, ContractNegotiation> action) {
        this.recordAction(ContractNegotiation.State.OFFERED, cn -> {
            cn.transition(ContractNegotiation.State.OFFERED);
            action.accept(this.baseAddress, (ContractNegotiation)cn);
        });
    }

    public void recordAgreedAction(BiConsumer<String, ContractNegotiation> action) {
        this.recordAction(ContractNegotiation.State.AGREED, cn -> action.accept(this.baseAddress, (ContractNegotiation)cn));
    }

    public void contractInitialized(ContractNegotiation negotiation) {
        this.received(ContractNegotiation.State.INITIALIZED, negotiation);
    }

    public void contractRequested(ContractNegotiation negotiation) {
        this.received(ContractNegotiation.State.REQUESTED, negotiation);
    }

    public void offered(ContractNegotiation negotiation) {
        this.received(ContractNegotiation.State.OFFERED, negotiation);
    }

    public void agreed(ContractNegotiation negotiation) {
        this.received(ContractNegotiation.State.AGREED, negotiation);
    }

    public void finalized(ContractNegotiation negotiation) {
        this.received(ContractNegotiation.State.FINALIZED, negotiation);
    }

    @Override
    public void verify() {
        super.verify();
        this.manager.deregisterListener((NegotiationListener)this);
    }

    private void received(ContractNegotiation.State state, ContractNegotiation negotiation) {
        NegotiationMock.Action action = (NegotiationMock.Action)this.actions.getOrDefault(state, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)negotiation));
    }
}

