/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector.tp;

import java.util.Map;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ConsumerTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.connector.tp.AbstractTransferProcessManager;

public class ConsumerTransferProcessManagerImpl
extends AbstractTransferProcessManager
implements ConsumerTransferProcessManager {
    private final Monitor monitor;

    public ConsumerTransferProcessManagerImpl(Monitor monitor) {
        super(monitor);
        this.monitor = monitor;
    }

    public TransferProcess createTransferProcess(String agreementId, String format, String providerBaseUrl, TransferProcess.DataAddress dataAddress) {
        TransferProcess transferProcess = TransferProcess.Builder.newInstance().agreementId(agreementId).format(format).callbackAddress(providerBaseUrl).dataAddress(dataAddress).transferKind(TransferProcess.TransferKind.Consumer).build();
        this.transferProcesses.put(transferProcess.getId(), transferProcess);
        this.listeners.forEach(l -> l.transferInitialized(transferProcess));
        return transferProcess;
    }

    public void transferRequested(String consumerId, String providerId) {
        TransferProcess transfer = this.findById(consumerId);
        transfer.setCorrelationId(providerId);
        transfer.transition(TransferProcess.State.REQUESTED, p -> this.listeners.forEach(l -> l.requested(transfer)));
    }

    @Override
    protected AbstractTransferProcessManager.TransferId parseId(Map<String, Object> message) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", message);
        String consumerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", message);
        return new AbstractTransferProcessManager.TransferId(consumerId, providerId);
    }
}

