/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector.tp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.TransferProcessListener;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.TransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.tp.TransferFunctions;
import org.eclipse.dataspacetck.dsp.system.api.service.Result;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransferProcessManager
implements TransferProcessManager {
    private final Monitor monitor;
    protected Map<String, TransferProcess> transferProcesses = new ConcurrentHashMap<String, TransferProcess>();
    protected Queue<TransferProcessListener> listeners = new ConcurrentLinkedQueue<TransferProcessListener>();

    protected AbstractTransferProcessManager(Monitor monitor) {
        this.monitor = monitor;
    }

    @NotNull
    public TransferProcess findById(String id) {
        return this.transferProcesses.get(id);
    }

    @Nullable
    public TransferProcess findByCorrelationId(String id) {
        return this.transferProcesses.values().stream().filter(n -> id.equals(n.getCorrelationId())).findAny().orElse(null);
    }

    public void registerListener(TransferProcessListener listener) {
        this.listeners.add(listener);
    }

    public void deregisterListener(TransferProcessListener listener) {
        this.listeners.remove(listener);
    }

    public void terminated(String providerId) {
        TransferProcess transfer = this.findById(providerId);
        transfer.transition(TransferProcess.State.TERMINATED);
    }

    public void completed(String providerId) {
        TransferProcess transfer = this.findById(providerId);
        transfer.transition(TransferProcess.State.COMPLETED);
    }

    public void suspended(String providerId) {
        TransferProcess transfer = this.findById(providerId);
        transfer.transition(TransferProcess.State.SUSPENDED);
    }

    public void started(String providerId) {
        TransferProcess transfer = this.findById(providerId);
        transfer.transition(TransferProcess.State.STARTED);
    }

    public Result<Map<String, Object>, Map<String, Object>> handleCompletion(Map<String, Object> completionMessage) {
        TransferId ids = this.parseId(completionMessage);
        this.monitor.debug(String.format("Received completion message: %s with correlation id %s", ids.id, ids.correlationId));
        TransferProcess transfer = this.findById(ids.id);
        return this.withStateTransition(transfer, tp -> {
            tp.transition(TransferProcess.State.COMPLETED, p -> this.listeners.forEach(l -> l.completed(p)));
            return TransferFunctions.createTransferResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)TransferProcess.State.COMPLETED.toString());
        });
    }

    public Map<String, Object> handleTermination(Map<String, Object> terminatedMessage) {
        TransferId ids = this.parseId(terminatedMessage);
        this.monitor.debug(String.format("Received terminated message: %s with correlation id %s", ids.id, ids.correlationId));
        TransferProcess transfer = this.findById(ids.id);
        transfer.transition(TransferProcess.State.TERMINATED, p -> this.listeners.forEach(l -> l.terminated(transfer)));
        return TransferFunctions.createTransferResponse((String)transfer.providerPid(), (String)transfer.consumerPid(), (String)TransferProcess.State.TERMINATED.toString());
    }

    public Result<Map<String, Object>, Map<String, Object>> handleSuspension(Map<String, Object> suspensionMessage) {
        TransferId ids = this.parseId(suspensionMessage);
        this.monitor.debug(String.format("Received suspension message: %s with correlation id %s", ids.id, ids.correlationId));
        TransferProcess transfer = this.findById(ids.id);
        return this.withStateTransition(transfer, tp -> {
            tp.transition(TransferProcess.State.SUSPENDED, p -> this.listeners.forEach(l -> l.suspended(p)));
            return TransferFunctions.createTransferResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)TransferProcess.State.SUSPENDED.toString());
        });
    }

    public Result<Map<String, Object>, Map<String, Object>> handleStart(Map<String, Object> startMessage, Predicate<TransferProcess.DataAddress> test) {
        TransferId ids = this.parseId(startMessage);
        this.monitor.debug(String.format("Received start message: %s with correlation id %s", ids.id, ids.correlationId));
        TransferProcess.DataAddress dataAddress = this.toDataAddress(JsonLdFunctions.mapProperty((String)"https://w3id.org/dspace/2025/1/dataAddress", startMessage, (boolean)true));
        if (!test.test(dataAddress)) {
            this.monitor.debug("Data address predicate failed");
            throw new AssertionError((Object)"Data address predicate failed");
        }
        TransferProcess transfer = this.findById(ids.id);
        return this.withStateTransition(transfer, tp -> {
            tp.setDataAddress(dataAddress);
            tp.transition(TransferProcess.State.STARTED, p -> this.listeners.forEach(l -> l.started(p)));
            return TransferFunctions.createTransferResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)TransferProcess.State.STARTED.toString());
        });
    }

    private TransferProcess.DataAddress toDataAddress(Map<String, Object> dataAddress) {
        if (dataAddress == null) {
            return null;
        }
        String endpointType = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/endpointType", dataAddress);
        String endpoint = null;
        if (dataAddress.get("https://w3id.org/dspace/2025/1/endpoint") != null) {
            endpoint = JsonLdFunctions.stringProperty((String)"https://w3id.org/dspace/2025/1/endpoint", dataAddress);
        }
        Map<String, String> endpointProperties = this.toEndpointProperties(dataAddress.get("https://w3id.org/dspace/2025/1/endpointProperties"));
        return new TransferProcess.DataAddress(endpointType, endpoint, endpointProperties);
    }

    private Map<String, String> toEndpointProperties(Object endpointProperties) {
        if (endpointProperties == null) {
            return Map.of();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (endpointProperties instanceof List) {
            for (Object property : (List)endpointProperties) {
                if (!(property instanceof Map)) continue;
                Map map = (Map)property;
                String name = JsonLdFunctions.stringProperty((String)"https://w3id.org/dspace/2025/1/name", (Map)map);
                String value = JsonLdFunctions.stringProperty((String)"https://w3id.org/dspace/2025/1/value", (Map)map);
                properties.put(name, value);
            }
        }
        return properties;
    }

    protected Result<Map<String, Object>, Map<String, Object>> withStateTransition(TransferProcess tp, Function<TransferProcess, Map<String, Object>> stateTransition) {
        try {
            return Result.success(stateTransition.apply(tp));
        }
        catch (IllegalStateException e) {
            return Result.failure((Object)TransferFunctions.createTransferErrorResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)"409", (String[])new String[]{e.getMessage()}), (Result.ErrorType)Result.ErrorType.CONFLICT);
        }
    }

    protected abstract TransferId parseId(Map<String, Object> var1);

    protected record TransferId(String id, String correlationId) {
    }
}

