/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector;

import java.util.Map;
import java.util.Objects;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.IdGenerator;
import org.eclipse.dataspacetck.dsp.system.api.connector.ProviderNegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.connector.AbstractNegotiationManager;
import org.jetbrains.annotations.NotNull;

public class ProviderNegotiationManagerImpl
extends AbstractNegotiationManager
implements ProviderNegotiationManager {
    public ProviderNegotiationManagerImpl(Monitor monitor) {
        super(monitor);
    }

    @Override
    protected AbstractNegotiationManager.NegotiationId parseId(Map<String, Object> message) {
        String providerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", message);
        String consumerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", message);
        return new AbstractNegotiationManager.NegotiationId(providerPid, consumerPid);
    }

    public void offered(String providerId) {
        ContractNegotiation negotiation = (ContractNegotiation)this.negotiations.get(providerId);
        negotiation.transition(ContractNegotiation.State.OFFERED, n -> this.listeners.forEach(l -> l.offered(n)));
    }

    public void agreed(String providerId) {
        ContractNegotiation negotiation = (ContractNegotiation)this.negotiations.get(providerId);
        negotiation.transition(ContractNegotiation.State.AGREED, n -> this.listeners.forEach(l -> l.agreed(n)));
    }

    public void finalized(String providerId) {
        ContractNegotiation negotiation = (ContractNegotiation)this.negotiations.get(providerId);
        negotiation.transition(ContractNegotiation.State.FINALIZED, n -> this.listeners.forEach(l -> l.finalized(n)));
    }

    public Map<String, Object> handleContractRequest(Map<String, Object> contractRequest, String counterPartyId) {
        ContractNegotiation negotiation;
        if (contractRequest.containsKey("https://w3id.org/dspace/2025/1/providerPid")) {
            String processId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", contractRequest);
            negotiation = this.handleCounterOffer(contractRequest, processId);
        } else {
            negotiation = this.handleInitialRequest(contractRequest, counterPartyId);
        }
        return NegotiationFunctions.createNegotiationResponse((String)negotiation.getId(), (String)negotiation.getCorrelationId(), (String)negotiation.getState().toString());
    }

    public void handleAccepted(Map<String, Object> event) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", event);
        JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/eventType", event);
        ContractNegotiation negotiation = (ContractNegotiation)this.negotiations.get(providerId);
        negotiation.transition(ContractNegotiation.State.ACCEPTED, n -> this.listeners.forEach(l -> l.agreed(negotiation)));
    }

    public void handleVerified(Map<String, Object> verification) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", verification);
        ContractNegotiation negotiation = this.findById(providerId);
        negotiation.transition(ContractNegotiation.State.VERIFIED, n -> this.listeners.forEach(l -> l.verified(n)));
    }

    public void terminated(Map<String, Object> termination) {
        String processId = Objects.requireNonNull(JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", termination));
        ContractNegotiation negotiation = (ContractNegotiation)this.negotiations.get(processId);
        negotiation.transition(ContractNegotiation.State.TERMINATED, n -> this.listeners.forEach(l -> l.terminated(n)));
    }

    @NotNull
    private ContractNegotiation handleCounterOffer(Map<String, Object> contractRequest, String processId) {
        ContractNegotiation negotiation = this.findById(processId);
        Map offer = JsonLdFunctions.mapProperty((String)"https://w3id.org/dspace/2025/1/offer", contractRequest);
        negotiation.storeOffer(offer, ContractNegotiation.State.REQUESTED, n -> this.listeners.forEach(l -> l.contractRequested(negotiation)));
        return negotiation;
    }

    @NotNull
    private ContractNegotiation handleInitialRequest(Map<String, Object> contractRequest, String counterPartyId) {
        String consumerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", contractRequest);
        ContractNegotiation previousNegotiation = this.findByCorrelationId(consumerPid);
        if (previousNegotiation != null) {
            return previousNegotiation;
        }
        Map offer = JsonLdFunctions.mapProperty((String)"https://w3id.org/dspace/2025/1/offer", contractRequest);
        String offerId = JsonLdFunctions.compactStringProperty((String)"@id", (Map)offer);
        String callbackAddress = JsonLdFunctions.stringProperty((String)"https://w3id.org/dspace/2025/1/callbackAddress", contractRequest);
        ContractNegotiation negotiation = ContractNegotiation.Builder.newInstance().correlationId(consumerPid).offerId(offerId).datasetId(IdGenerator.datasetIdFromOfferId((String)offerId)).state(ContractNegotiation.State.REQUESTED).counterPartyId(counterPartyId).callbackAddress(callbackAddress).negotiationKind(ContractNegotiation.NegotiationKind.Provider).build();
        this.negotiations.put(negotiation.getId(), negotiation);
        this.listeners.forEach(l -> l.contractRequested(negotiation));
        return negotiation;
    }
}

