/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector;

import java.util.Map;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.ConsumerNegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.connector.AbstractNegotiationManager;

public class ConsumerNegotiationManagerImpl
extends AbstractNegotiationManager
implements ConsumerNegotiationManager {
    private final Monitor monitor;

    public ConsumerNegotiationManagerImpl(Monitor monitor) {
        super(monitor);
        this.monitor = monitor;
    }

    public ContractNegotiation createNegotiation(String datasetId, String offerId, String callbackAddress) {
        ContractNegotiation.Builder negotiationBuilder = ContractNegotiation.Builder.newInstance().datasetId(datasetId).offerId(offerId).negotiationKind(ContractNegotiation.NegotiationKind.Consumer);
        if (callbackAddress != null) {
            negotiationBuilder.callbackAddress(callbackAddress);
        }
        ContractNegotiation negotiation = negotiationBuilder.build();
        this.negotiations.put(negotiation.getId(), negotiation);
        this.listeners.forEach(l -> l.contractInitialized(negotiation));
        return negotiation;
    }

    public void contractRequested(String consumerId, String providerId) {
        ContractNegotiation negotiation = this.getNegotiations().get(consumerId);
        negotiation.setCorrelationId(providerId, ContractNegotiation.State.REQUESTED);
        this.listeners.forEach(l -> l.contractRequested(negotiation));
    }

    public void counterOffered(String consumerId) {
        ContractNegotiation negotiation = this.getNegotiations().get(consumerId);
        negotiation.transition(ContractNegotiation.State.REQUESTED, n -> this.listeners.forEach(l -> l.offered(n)));
    }

    public void accepted(String consumerId) {
        ContractNegotiation negotiation = this.getNegotiations().get(consumerId);
        negotiation.transition(ContractNegotiation.State.ACCEPTED, n -> this.listeners.forEach(l -> l.agreed(n)));
    }

    public void verified(String consumerId) {
        ContractNegotiation negotiation = this.getNegotiations().get(consumerId);
        negotiation.transition(ContractNegotiation.State.VERIFIED, n -> this.listeners.forEach(l -> l.verified(n)));
    }

    @Override
    public void terminated(String consumerId) {
        ContractNegotiation negotiation = this.getNegotiations().get(consumerId);
        negotiation.transition(ContractNegotiation.State.TERMINATED, n -> this.listeners.forEach(l -> l.terminated(n)));
    }

    public Map<String, Object> handleOffer(Map<String, Object> offer) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", offer);
        this.monitor.debug("Received provider offer: " + providerId);
        String consumerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", offer);
        ContractNegotiation negotiation = this.findById(consumerId);
        negotiation.storeOffer(offer, ContractNegotiation.State.OFFERED, n -> this.listeners.forEach(l -> l.offered(negotiation)));
        return NegotiationFunctions.createNegotiationResponse((String)negotiation.getCorrelationId(), (String)negotiation.getId(), (String)ContractNegotiation.State.OFFERED.toString());
    }

    public void handleAgreement(Map<String, Object> agreement) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", agreement);
        this.monitor.debug("Received provider agreement: " + providerId);
        String consumerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", agreement);
        ContractNegotiation negotiation = this.findById(consumerId);
        negotiation.storeAgreement(agreement, n -> this.listeners.forEach(l -> l.agreed(negotiation)));
    }

    public void handleFinalized(Map<String, Object> event) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", event);
        this.monitor.debug("Received provider finalize: " + providerId);
        String consumerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", event);
        ContractNegotiation negotiation = this.findById(consumerId);
        negotiation.transition(ContractNegotiation.State.FINALIZED, n -> this.listeners.forEach(l -> l.finalized(negotiation)));
    }

    @Override
    protected AbstractNegotiationManager.NegotiationId parseId(Map<String, Object> message) {
        String providerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", message);
        String consumerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", message);
        return new AbstractNegotiationManager.NegotiationId(consumerPid, providerPid);
    }
}

