/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.tp.local;

import java.util.Map;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.tp.TransferFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.client.tp.ProviderTransferProcessClient;

public class LocalProviderTransferProcessClient
implements ProviderTransferProcessClient {
    private final Connector systemConnector;

    public LocalProviderTransferProcessClient(Connector systemConnector) {
        this.systemConnector = systemConnector;
    }

    @Override
    public Map<String, Object> transferRequest(Map<String, Object> transferRequest, String counterPartyId, boolean expectError) {
        try {
            Map compacted = MessageSerializer.processJsonLd(transferRequest);
            Map transferProcess = this.systemConnector.getProviderTransferProcessManager().handleTransferRequest(compacted, counterPartyId);
            if (expectError) {
                throw new AssertionError((Object)"Expected to throw an error on transfer request");
            }
            return MessageSerializer.processJsonLd((Map)transferProcess);
        }
        catch (IllegalStateException e) {
            if (!expectError) {
                throw e;
            }
            return Map.of();
        }
    }

    @Override
    public void terminateTransfer(String counterPartyPid, Map<String, Object> terminationMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getProviderTransferProcessManager().handleTermination(MessageSerializer.processJsonLd(terminationMessage));
    }

    @Override
    public void completeTransfer(String counterPartyPid, Map<String, Object> completionMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getProviderTransferProcessManager().handleCompletion(MessageSerializer.processJsonLd(completionMessage));
    }

    @Override
    public void suspendTransfer(String counterPartyPid, Map<String, Object> suspensionMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getProviderTransferProcessManager().handleSuspension(MessageSerializer.processJsonLd(suspensionMessage));
    }

    @Override
    public void startTransfer(String counterPartiPid, Map<String, Object> startMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getProviderTransferProcessManager().handleStart(MessageSerializer.processJsonLd(startMessage));
    }

    @Override
    public Map<String, Object> getTransferProcess(String counterPartyPid, String callbackAddress) {
        TransferProcess tp = this.systemConnector.getProviderTransferProcessManager().findById(counterPartyPid);
        return MessageSerializer.processJsonLd((Map)TransferFunctions.createTransferResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)tp.getState().toString()));
    }
}

