/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.tp.local;

import java.util.Map;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.tp.TransferFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.client.tp.ConsumerTransferProcessClient;

public class LocalConsumerTransferProcessClient
implements ConsumerTransferProcessClient {
    private final Connector systemConnector;

    public LocalConsumerTransferProcessClient(Connector systemConnector) {
        this.systemConnector = systemConnector;
    }

    @Override
    public void initiateTransferRequest(String agreementId, String format) {
        this.systemConnector.getConsumerTransferProcessManager().createTransferProcess(agreementId, format, null, null);
    }

    @Override
    public void terminateTransfer(String counterPartyPid, Map<String, Object> terminationMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getConsumerTransferProcessManager().handleTermination(MessageSerializer.processJsonLd(terminationMessage));
    }

    @Override
    public void completeTransfer(String counterPartyPid, Map<String, Object> completionMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getConsumerTransferProcessManager().handleCompletion(MessageSerializer.processJsonLd(completionMessage));
    }

    @Override
    public void suspendTransfer(String counterPartyPid, Map<String, Object> suspensionMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getConsumerTransferProcessManager().handleSuspension(MessageSerializer.processJsonLd(suspensionMessage));
    }

    @Override
    public void startTransfer(String counterPartiPid, Map<String, Object> startMessage, String callbackAddress, boolean expectError) {
        this.systemConnector.getConsumerTransferProcessManager().handleStart(MessageSerializer.processJsonLd(startMessage));
    }

    @Override
    public Map<String, Object> getTransferProcess(String counterPartyPid, String callbackAddress) {
        TransferProcess tp = this.systemConnector.getConsumerTransferProcessManager().findById(counterPartyPid);
        return MessageSerializer.processJsonLd((Map)TransferFunctions.createTransferResponse((String)tp.providerPid(), (String)tp.consumerPid(), (String)tp.getState().toString()));
    }
}

