/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.tp.http;

import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.client.tp.TransferProcessClient;

public abstract class AbstractHttpTransferProcessClientImpl
implements TransferProcessClient {
    private static final String GET_PATH = "/transfers/%s";
    private static final String START_PATH = "%s/transfers/%s/start";
    private static final String COMPLETION_PATH = "%s/transfers/%s/completion";
    private static final String SUSPENSION_PATH = "%s/transfers/%s/suspension";
    private static final String TERMINATION_PATH = "%s/transfers/%s/termination";
    protected final Monitor monitor;

    protected AbstractHttpTransferProcessClientImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void completeTransfer(String counterPartyPid, Map<String, Object> completionMessage, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(COMPLETION_PATH, callbackAddress, counterPartyPid), completionMessage, (boolean)expectError);){
            this.monitor.debug("Received completion request response");
        }
    }

    @Override
    public void suspendTransfer(String counterPartyPid, Map<String, Object> suspensionMessage, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(SUSPENSION_PATH, callbackAddress, counterPartyPid), suspensionMessage, (boolean)expectError);){
            this.monitor.debug("Received suspension request response");
        }
    }

    @Override
    public void startTransfer(String counterPartiPid, Map<String, Object> offer, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(START_PATH, callbackAddress, counterPartiPid), offer, (boolean)expectError);){
            this.monitor.debug("Received start request response");
        }
    }

    @Override
    public void terminateTransfer(String counterPartyPid, Map<String, Object> terminationMessage, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(TERMINATION_PATH, callbackAddress, counterPartyPid), terminationMessage, (boolean)expectError);){
            this.monitor.debug("Received termination request response");
        }
    }

    @Override
    public Map<String, Object> getTransferProcess(String counterPartyPid, String callbackAddress) {
        try (Response response = HttpFunctions.getJson((String)(callbackAddress + String.format(GET_PATH, counterPartyPid)));){
            Map jsonResponse = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", (Map)jsonResponse);
            String state = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/state", (Map)jsonResponse);
            this.monitor.debug(String.format("Received transfer status response with state %s: %s", state, providerId));
            Map map = jsonResponse;
            return map;
        }
    }
}

