/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.cn.http;

import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.client.cn.ProviderNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.http.AbstractHttpNegotiationClient;

public class HttpProviderNegotiationClientImpl
extends AbstractHttpNegotiationClient
implements ProviderNegotiationClient {
    private static final String GET_PATH = "negotiations/%s";
    private static final String REQUEST_PATH = "negotiations/request";
    private static final String EVENT_PATH = "negotiations/%s/events";
    private static final String VERIFICATION_PATH = "negotiations/%s/agreement/verification";
    private static final String REQUEST_OFFER_PATH = "negotiations/%s/request";
    private final Monitor monitor;
    private final String providerConnectorBaseUrl;
    private Connector systemConnector;

    public HttpProviderNegotiationClientImpl(String connectorBaseUrl, Monitor monitor) {
        super(monitor);
        this.providerConnectorBaseUrl = connectorBaseUrl.endsWith("/") ? connectorBaseUrl : connectorBaseUrl + "/";
        this.monitor = monitor;
    }

    @Override
    public Map<String, Object> contractRequest(Map<String, Object> contractRequest, String counterPartyId, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)(this.providerConnectorBaseUrl + REQUEST_PATH), contractRequest, (boolean)expectError);){
            this.monitor.debug("Received contract request response");
            Map map = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            return map;
        }
    }

    @Override
    public void contractOfferRequest(Map<String, Object> contractRequest, String counterPartyId, boolean expectError) {
        String providerId = JsonLdFunctions.compactStringProperty((String)"providerPid", contractRequest);
        try (Response response = HttpFunctions.postJson((String)(this.providerConnectorBaseUrl + String.format(REQUEST_OFFER_PATH, providerId)), contractRequest, (boolean)expectError);){
            this.monitor.debug("Received contract offer request response");
        }
    }

    @Override
    public void accept(Map<String, Object> event) {
        String providerId = JsonLdFunctions.compactStringProperty((String)"providerPid", event);
        try (Response response = HttpFunctions.postJson((String)(this.providerConnectorBaseUrl + String.format(EVENT_PATH, providerId)), event);){
            if (!response.isSuccessful()) {
                throw new AssertionError((Object)String.format("Accept event failed with code %s: %s ", response.code(), providerId));
            }
            this.monitor.debug("Received accept response: " + providerId);
        }
    }

    @Override
    public void verify(Map<String, Object> event, boolean expectError) {
        String providerId = JsonLdFunctions.compactStringProperty((String)"providerPid", event);
        try (Response response = HttpFunctions.postJson((String)(this.providerConnectorBaseUrl + String.format(VERIFICATION_PATH, providerId)), event, (boolean)expectError);){
            this.validateResponse(response, providerId, expectError, "verify");
            this.monitor.debug("Received verification response: " + providerId);
        }
    }

    @Override
    public Map<String, Object> getNegotiation(String providerPid) {
        try (Response response = HttpFunctions.getJson((String)(this.providerConnectorBaseUrl + String.format(GET_PATH, providerPid)));){
            Map jsonResponse = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", (Map)jsonResponse);
            String state = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/state", (Map)jsonResponse);
            this.monitor.debug(String.format("Received negotiation status response with state %s: %s", state, providerId));
            Map map = jsonResponse;
            return map;
        }
    }

    private void validateResponse(Response response, String providerId, boolean expectError, String type) {
        if (expectError) {
            if (response.isSuccessful()) {
                throw new AssertionError((Object)String.format("Invalid %s did not fail: %s", type, providerId));
            }
        } else if (!response.isSuccessful()) {
            throw new AssertionError((Object)String.format("Request %s failed with code %s: %s", type, response.code(), providerId));
        }
    }
}

