/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.cn.http;

import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.client.cn.ConsumerNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.http.AbstractHttpNegotiationClient;

public class HttpConsumerNegotiationClientImpl
extends AbstractHttpNegotiationClient
implements ConsumerNegotiationClient {
    private static final String GET_PATH = "%s/negotiations/%s";
    private static final String TERMINATE_PATH = "%s/negotiations/%s/termination";
    private static final String OFFERS_PATH = "%s/negotiations/%s/offers";
    private static final String AGREEMENTS_PATH = "%s/negotiations/%s/agreement";
    private static final String FINALIZE_PATH = "%s/negotiations/%s/events";
    private final Monitor monitor;
    private final String consumerConnectorInitiateUrl;
    private final String providerConnectorBaseUrl;

    public HttpConsumerNegotiationClientImpl(String consumerConnectorInitiateUrl, String providerConnectorBaseUrl, Monitor monitor) {
        super(monitor);
        this.consumerConnectorInitiateUrl = consumerConnectorInitiateUrl;
        this.providerConnectorBaseUrl = providerConnectorBaseUrl;
        this.monitor = monitor;
    }

    @Override
    public void initiateRequest(String datasetId, String offerId) {
        Map<String, String> request = Map.of("providerId", "TCK_PARTICIPANT", "offerId", offerId, "datasetId", datasetId, "connectorAddress", this.providerConnectorBaseUrl);
        try (Response response = HttpFunctions.postJson((String)this.consumerConnectorInitiateUrl, request, (boolean)false, (boolean)true);){
            this.monitor.debug("Received contract request response");
        }
    }

    @Override
    public void contractOffer(String consumerId, Map<String, Object> offer, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(OFFERS_PATH, callbackAddress, consumerId), offer, (boolean)expectError);){
            this.monitor.debug("Received contract request response");
        }
    }

    @Override
    public void contractAgreement(String consumerId, Map<String, Object> agreement, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(AGREEMENTS_PATH, callbackAddress, consumerId), agreement, (boolean)expectError);){
            this.monitor.debug("Received contract agreement response");
        }
    }

    @Override
    public void finalize(String consumerId, Map<String, Object> event, String callbackAddress, boolean expectError) {
        try (Response response = HttpFunctions.postJson((String)String.format(FINALIZE_PATH, callbackAddress, consumerId), event, (boolean)expectError);){
            this.monitor.debug("Received contract finalize response");
        }
    }

    @Override
    public Map<String, Object> getNegotiation(String consumerId, String callbackAddress) {
        try (Response response = HttpFunctions.getJson((String)String.format(GET_PATH, callbackAddress, consumerId));){
            Map jsonResponse = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", (Map)jsonResponse);
            String state = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/state", (Map)jsonResponse);
            this.monitor.debug(String.format("Received negotiation status response with state %s: %s", state, providerId));
            Map map = jsonResponse;
            return map;
        }
    }
}

