/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.dataspacetck.core.api.system.CallbackEndpoint;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.core.spi.system.ServiceConfiguration;
import org.eclipse.dataspacetck.core.spi.system.ServiceResolver;
import org.eclipse.dataspacetck.core.spi.system.SystemConfiguration;
import org.eclipse.dataspacetck.core.spi.system.SystemLauncher;
import org.eclipse.dataspacetck.dsp.system.api.client.catalog.CatalogClient;
import org.eclipse.dataspacetck.dsp.system.api.client.metadata.MetadataClient;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.connector.Consumer;
import org.eclipse.dataspacetck.dsp.system.api.connector.ConsumerNegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ConsumerTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ProviderTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.mock.ConsumerNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.ProviderNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.ConsumerTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.ProviderTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ConsumerNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ProviderNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.tp.ConsumerTransferProcessPipeline;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.tp.ProviderTransferProcessPipeline;
import org.eclipse.dataspacetck.dsp.system.client.catalog.http.HttpCatalogClient;
import org.eclipse.dataspacetck.dsp.system.client.catalog.local.LocalCatalogClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.ConsumerNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.ProviderNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.http.HttpConsumerNegotiationClientImpl;
import org.eclipse.dataspacetck.dsp.system.client.cn.http.HttpProviderNegotiationClientImpl;
import org.eclipse.dataspacetck.dsp.system.client.cn.local.LocalConsumerNegotiationClientImpl;
import org.eclipse.dataspacetck.dsp.system.client.cn.local.LocalProviderNegotiationClientImpl;
import org.eclipse.dataspacetck.dsp.system.client.metadata.http.HttpMetadataClient;
import org.eclipse.dataspacetck.dsp.system.client.metadata.local.LocalMetadataClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.ConsumerTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.ProviderTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.http.HttpConsumerTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.http.HttpProviderTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.local.LocalConsumerTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.client.tp.local.LocalProviderTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.connector.TckConnector;
import org.eclipse.dataspacetck.dsp.system.mock.ConsumerNegotiationMockImpl;
import org.eclipse.dataspacetck.dsp.system.mock.NoOpConsumerNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.mock.NoOpProviderNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.mock.ProviderNegotiationMockImpl;
import org.eclipse.dataspacetck.dsp.system.mock.tp.ConsumerTransferProcessMockImpl;
import org.eclipse.dataspacetck.dsp.system.mock.tp.NoOpConsumerTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.mock.tp.NoOpProviderTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.mock.tp.ProviderTransferProcessMockImpl;
import org.eclipse.dataspacetck.dsp.system.pipeline.ConsumerNegotiationPipelineImpl;
import org.eclipse.dataspacetck.dsp.system.pipeline.ProviderNegotiationPipelineImpl;
import org.eclipse.dataspacetck.dsp.system.pipeline.tp.ConsumerTransferProcessPipelineImpl;
import org.eclipse.dataspacetck.dsp.system.pipeline.tp.ProviderTransferProcessPipelineImpl;
import org.jetbrains.annotations.Nullable;

public class DspSystemLauncher
implements SystemLauncher {
    private static final String LOCAL_CONNECTOR_CONFIG = "dataspacetck.dsp.local.connector";
    private static final String CONNECTOR_AGENT_ID_CONFIG = "dataspacetck.dsp.connector.agent.id";
    private static final String CONNECTOR_PROTOCOL_URL_CONFIG = "dataspacetck.dsp.connector.http.url";
    private static final String CONNECTOR_BASE_URL_CONFIG = "dataspacetck.dsp.connector.http.base.url";
    private static final String CONNECTOR_BASE_AUTHORIZATION_HEADER_CONFIG = "dataspacetck.dsp.connector.http.headers.authorization";
    private static final String CONNECTOR_INITIATE_URL_CONFIG = "dataspacetck.dsp.connector.negotiation.initiate.url";
    private static final String CONNECTOR_TRANSFER_INITIATE_URL_CONFIG = "dataspacetck.dsp.connector.transfer.initiate.url";
    private static final String THREAD_POOL_CONFIG = "dataspacetck.dsp.thread.pool";
    private static final String DEFAULT_WAIT_CONFIG = "dataspacetck.dsp.default.wait";
    private static final int DEFAULT_WAIT_SECONDS = 15;
    private final Map<String, Connector> consumerConnectors = new ConcurrentHashMap<String, Connector>();
    private final Map<String, Connector> providerConnectors = new ConcurrentHashMap<String, Connector>();
    private final Map<String, ProviderNegotiationMock> negotiationMocks = new ConcurrentHashMap<String, ProviderNegotiationMock>();
    private final Map<String, ProviderNegotiationClient> negotiationClients = new ConcurrentHashMap<String, ProviderNegotiationClient>();
    private final Map<String, ProviderTransferProcessClient> providerTransferClients = new ConcurrentHashMap<String, ProviderTransferProcessClient>();
    private final Map<String, ConsumerTransferProcessClient> consumerTransferClients = new ConcurrentHashMap<String, ConsumerTransferProcessClient>();
    private final Map<String, ConsumerTransferProcessMock> consumerTransferMocks = new ConcurrentHashMap<String, ConsumerTransferProcessMock>();
    private final Map<String, ProviderTransferProcessMock> providerTransferMocks = new ConcurrentHashMap<String, ProviderTransferProcessMock>();
    private final Map<String, ConsumerNegotiationMock> consumerNegotiationMocks = new ConcurrentHashMap<String, ConsumerNegotiationMock>();
    private final Map<String, ConsumerNegotiationClient> consumerNegotiationClients = new ConcurrentHashMap<String, ConsumerNegotiationClient>();
    private final Map<String, CatalogClient> providerCatalogClients = new ConcurrentHashMap<String, CatalogClient>();
    private final Map<String, MetadataClient> providerMetadataClients = new ConcurrentHashMap<String, MetadataClient>();
    private Monitor monitor;
    private ExecutorService executor;
    private String connectorUnderTestId = "ANONYMOUS";
    private String connectorProtocolUrl;
    private String connectorBaseUrl;
    private String baseAuthorizationHeader;
    private String connectorInitiateUrl;
    private String connectorTransferInitiateUrl;
    private boolean useLocalConnector;
    private long waitTime = 15L;

    public void start(SystemConfiguration configuration) {
        this.monitor = configuration.getMonitor();
        this.waitTime = configuration.getPropertyAsLong(DEFAULT_WAIT_CONFIG, 15L);
        this.executor = Executors.newFixedThreadPool(configuration.getPropertyAsInt(THREAD_POOL_CONFIG, 10));
        this.useLocalConnector = configuration.getPropertyAsBoolean(LOCAL_CONNECTOR_CONFIG, false);
        if (!this.useLocalConnector) {
            this.connectorProtocolUrl = configuration.getPropertyAsString(CONNECTOR_PROTOCOL_URL_CONFIG, null);
            if (this.connectorProtocolUrl == null) {
                throw new RuntimeException("Required configuration not set: dataspacetck.dsp.connector.http.url");
            }
            this.connectorBaseUrl = configuration.getPropertyAsString(CONNECTOR_BASE_URL_CONFIG, null);
            if (this.connectorBaseUrl == null) {
                throw new RuntimeException("Required configuration not set: dataspacetck.dsp.connector.http.base.url");
            }
            this.baseAuthorizationHeader = configuration.getPropertyAsString(CONNECTOR_BASE_AUTHORIZATION_HEADER_CONFIG, null);
            if (this.baseAuthorizationHeader != null) {
                HttpFunctions.registerAuthorizationInterceptor((String)this.baseAuthorizationHeader);
            }
            this.connectorInitiateUrl = configuration.getPropertyAsString(CONNECTOR_INITIATE_URL_CONFIG, null);
            if (this.connectorInitiateUrl == null) {
                throw new RuntimeException("Required configuration not set: dataspacetck.dsp.connector.negotiation.initiate.url");
            }
            this.connectorTransferInitiateUrl = configuration.getPropertyAsString(CONNECTOR_TRANSFER_INITIATE_URL_CONFIG, null);
            if (this.connectorTransferInitiateUrl == null) {
                throw new RuntimeException("Required configuration not set: dataspacetck.dsp.connector.transfer.initiate.url");
            }
            this.connectorUnderTestId = configuration.getPropertyAsString(CONNECTOR_AGENT_ID_CONFIG, null);
            if (this.connectorUnderTestId == null) {
                throw new RuntimeException("Required configuration not set: dataspacetck.dsp.connector.agent.id");
            }
        }
    }

    public void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public <T> boolean providesService(Class<T> type) {
        return type.equals(ProviderNegotiationClient.class) || type.equals(Connector.class) || type.equals(ProviderNegotiationMock.class) || type.equals(ConsumerNegotiationMock.class) || type.equals(ConsumerNegotiationPipeline.class) || type.equals(ProviderNegotiationPipeline.class) || type.equals(ConsumerTransferProcessPipeline.class) || type.equals(ProviderTransferProcessPipeline.class) || type.equals(ConsumerTransferProcessMock.class) || type.equals(ProviderTransferProcessMock.class);
    }

    @Nullable
    public <T> T getService(Class<T> type, ServiceConfiguration configuration, ServiceResolver resolver) {
        if (ProviderNegotiationPipeline.class.equals(type)) {
            return this.createProviderPipeline(type, configuration, resolver);
        }
        if (ConsumerNegotiationPipeline.class.equals(type)) {
            return this.createConsumerPipeline(type, configuration, resolver);
        }
        if (Connector.class.equals(type)) {
            return this.createConnector(type, configuration);
        }
        if (ProviderNegotiationMock.class.equals(type)) {
            return this.createProviderNegotiationMock(type, configuration.getScopeId());
        }
        if (ConsumerNegotiationMock.class.equals(type)) {
            return this.createConsumerNegotiationMock(type, configuration.getScopeId(), configuration, resolver);
        }
        if (ProviderNegotiationClient.class.equals(type)) {
            return type.cast(this.createNegotiationClient(configuration.getScopeId()));
        }
        if (ConsumerNegotiationClient.class.equals(type)) {
            return type.cast(this.createConsumerNegotiationClient(configuration.getScopeId(), configuration, resolver));
        }
        if (ProviderTransferProcessPipeline.class.equals(type)) {
            return type.cast(this.createProviderTransferProcessPipeline(configuration, resolver));
        }
        if (ConsumerTransferProcessPipeline.class.equals(type)) {
            return type.cast(this.createConsumerTransferProcessPipeline(configuration, resolver));
        }
        if (ConsumerTransferProcessMock.class.equals(type)) {
            return type.cast(this.createConsumerTransferProcessMock(type, configuration.getScopeId(), configuration, resolver));
        }
        if (ProviderTransferProcessMock.class.equals(type)) {
            return type.cast(this.createProviderTransferProcessMock(type, configuration.getScopeId(), configuration, resolver));
        }
        if (CatalogClient.class.equals(type)) {
            return type.cast(this.createCatalogClient(configuration.getScopeId(), configuration, resolver));
        }
        if (MetadataClient.class.equals(type)) {
            return type.cast(this.createMetadataClient(configuration.getScopeId(), configuration, resolver));
        }
        return null;
    }

    private <T> T createProviderPipeline(Class<T> type, ServiceConfiguration configuration, ServiceResolver resolver) {
        String scopeId = configuration.getScopeId();
        ProviderNegotiationClient negotiationClient = this.createNegotiationClient(scopeId);
        CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
        Connector consumerConnector = this.consumerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor));
        ProviderNegotiationPipelineImpl pipeline = new ProviderNegotiationPipelineImpl(negotiationClient, callbackEndpoint, consumerConnector, this.connectorProtocolUrl, this.connectorUnderTestId, this.monitor, this.waitTime);
        return type.cast((Object)pipeline);
    }

    private <T> T createConsumerPipeline(Class<T> type, ServiceConfiguration configuration, ServiceResolver resolver) {
        String scopeId = configuration.getScopeId();
        ConsumerNegotiationClient negotiationClient = this.createConsumerNegotiationClient(scopeId, configuration, resolver);
        CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
        Connector providerConnector = this.providerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor));
        ConsumerNegotiationPipelineImpl pipeline = new ConsumerNegotiationPipelineImpl(negotiationClient, callbackEndpoint, providerConnector, this.connectorUnderTestId, this.monitor, this.waitTime);
        return type.cast((Object)pipeline);
    }

    private <T> T createProviderNegotiationMock(Class<T> type, String scopeId) {
        return type.cast(this.negotiationMocks.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector connector = this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                return new ProviderNegotiationMockImpl(connector.getProviderNegotiationManager(), this.executor);
            }
            return new NoOpProviderNegotiationMock();
        }));
    }

    private <T> T createConsumerNegotiationMock(Class<T> type, String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return type.cast(this.consumerNegotiationMocks.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector connector = this.consumerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                ConsumerNegotiationManager negotiationManager = connector.getConsumerNegotiationManager();
                CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
                String address = callbackEndpoint.getAddress();
                return new ConsumerNegotiationMockImpl(negotiationManager, this.executor, address);
            }
            return new NoOpConsumerNegotiationMock();
        }));
    }

    private <T> T createConnector(Class<T> type, ServiceConfiguration configuration) {
        String scopeId = configuration.getScopeId();
        if (configuration.getAnnotations().stream().anyMatch(a -> a.annotationType().equals(Consumer.class))) {
            return type.cast(this.consumerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor)));
        }
        return type.cast(this.providerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor)));
    }

    private ProviderNegotiationClient createNegotiationClient(String scopeId) {
        return this.negotiationClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                return new LocalProviderNegotiationClientImpl(this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor)));
            }
            return new HttpProviderNegotiationClientImpl(this.connectorProtocolUrl, this.monitor);
        });
    }

    private ConsumerNegotiationClient createConsumerNegotiationClient(String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return this.consumerNegotiationClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector consumerConnector = this.consumerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                return new LocalConsumerNegotiationClientImpl(consumerConnector);
            }
            CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
            assert (callbackEndpoint != null);
            return new HttpConsumerNegotiationClientImpl(this.connectorInitiateUrl, callbackEndpoint.getAddress(), this.monitor);
        });
    }

    private ConsumerTransferProcessPipeline createConsumerTransferProcessPipeline(ServiceConfiguration configuration, ServiceResolver resolver) {
        String scopeId = configuration.getScopeId();
        ConsumerTransferProcessClient transferClient = this.createConsumerTransferProcessClientClient(scopeId, configuration, resolver);
        CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
        Connector providerConnector = this.providerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor));
        return new ConsumerTransferProcessPipelineImpl(transferClient, callbackEndpoint, providerConnector, this.connectorUnderTestId, this.monitor, this.waitTime);
    }

    private ProviderTransferProcessPipeline createProviderTransferProcessPipeline(ServiceConfiguration configuration, ServiceResolver resolver) {
        String scopeId = configuration.getScopeId();
        ProviderTransferProcessClient negotiationClient = this.createProviderTransferProcessClientClient(scopeId, configuration, resolver);
        CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
        Connector consumerConnector = this.consumerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor));
        return new ProviderTransferProcessPipelineImpl(negotiationClient, callbackEndpoint, consumerConnector, this.connectorProtocolUrl, this.connectorUnderTestId, this.monitor, this.waitTime);
    }

    private ConsumerTransferProcessClient createConsumerTransferProcessClientClient(String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        Connector providerConnector = this.providerConnectors.computeIfAbsent(scopeId, k -> new TckConnector(this.monitor));
        return this.consumerTransferClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector consumerConnector = this.consumerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
                return new LocalConsumerTransferProcessClient(consumerConnector);
            }
            CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
            assert (callbackEndpoint != null);
            return new HttpConsumerTransferProcessClient(this.connectorTransferInitiateUrl, callbackEndpoint.getAddress(), this.monitor);
        });
    }

    private ProviderTransferProcessClient createProviderTransferProcessClientClient(String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return this.providerTransferClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                return new LocalProviderTransferProcessClient(this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor)));
            }
            return new HttpProviderTransferProcessClient(this.connectorProtocolUrl, this.monitor);
        });
    }

    private <T> T createConsumerTransferProcessMock(Class<T> type, String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return type.cast(this.consumerTransferMocks.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector connector = this.consumerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                ConsumerTransferProcessManager manager = connector.getConsumerTransferProcessManager();
                CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
                String address = callbackEndpoint.getAddress();
                return new ConsumerTransferProcessMockImpl(manager, this.executor, address);
            }
            return new NoOpConsumerTransferProcessMock();
        }));
    }

    private <T> T createProviderTransferProcessMock(Class<T> type, String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return type.cast(this.providerTransferMocks.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                Connector connector = this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor));
                ProviderTransferProcessManager manager = connector.getProviderTransferProcessManager();
                CallbackEndpoint callbackEndpoint = (CallbackEndpoint)resolver.resolve(CallbackEndpoint.class, configuration);
                String address = callbackEndpoint.getAddress();
                return new ProviderTransferProcessMockImpl(manager, this.executor, address);
            }
            return new NoOpProviderTransferProcessMock();
        }));
    }

    private CatalogClient createCatalogClient(String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return this.providerCatalogClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                return new LocalCatalogClient(this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor)));
            }
            return new HttpCatalogClient(this.connectorProtocolUrl, this.monitor);
        });
    }

    private MetadataClient createMetadataClient(String scopeId, ServiceConfiguration configuration, ServiceResolver resolver) {
        return this.providerMetadataClients.computeIfAbsent(scopeId, k -> {
            if (this.useLocalConnector) {
                return new LocalMetadataClient(this.providerConnectors.computeIfAbsent(scopeId, k2 -> new TckConnector(this.monitor)));
            }
            return new HttpMetadataClient(this.connectorBaseUrl, this.monitor);
        });
    }
}

