/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.pipeline.tp;

import java.util.Map;
import org.eclipse.dataspacetck.core.api.system.CallbackEndpoint;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.tp.TransferFunctions;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.tp.ProviderTransferProcessPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.client.tp.ProviderTransferProcessClient;
import org.eclipse.dataspacetck.dsp.system.pipeline.tp.AbstractTransferProcessPipeline;

public class ProviderTransferProcessPipelineImpl
extends AbstractTransferProcessPipeline<ProviderTransferProcessPipeline>
implements ProviderTransferProcessPipeline {
    private final ProviderTransferProcessClient transferProcessClient;
    private final Connector consumerConnector;
    private final String providerBaseUrl;
    private final String providerConnectorId;

    public ProviderTransferProcessPipelineImpl(ProviderTransferProcessClient transferProcessClient, CallbackEndpoint endpoint, Connector consumerConnector, String providerBaseUrl, String providerConnectorId, Monitor monitor, long waitTime) {
        super(transferProcessClient, endpoint, monitor, waitTime);
        this.transferProcessClient = transferProcessClient;
        this.consumerConnector = consumerConnector;
        this.providerBaseUrl = providerBaseUrl;
        this.providerConnectorId = providerConnectorId;
    }

    public ProviderTransferProcessPipeline sendTransferRequest(String agreementId, String format, TransferProcess.DataAddress dataAddress) {
        this.stages.add(() -> {
            this.transferProcess = this.consumerConnector.getConsumerTransferProcessManager().createTransferProcess(agreementId, format, this.providerBaseUrl, dataAddress);
            Map contractRequest = TransferFunctions.createTransferRequest((String)this.transferProcess.getId(), (String)this.transferProcess.getAgreementId(), (String)this.transferProcess.getFormat(), (TransferProcess.DataAddress)this.transferProcess.getDataAddress(), (String)this.endpoint.getAddress());
            this.monitor.debug("Sending transfer request");
            Map<String, Object> response = this.transferProcessClient.transferRequest(contractRequest, this.providerConnectorId, false);
            String correlationId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", response);
            this.consumerConnector.getConsumerTransferProcessManager().transferRequested(this.transferProcess.getId(), correlationId);
        });
        return this;
    }

    @Override
    protected ProviderTransferProcessPipeline self() {
        return this;
    }

    public ProviderTransferProcessPipeline thenVerifyProviderState(TransferProcess.State state) {
        this.thenWait("for provider transfer process state to be " + String.valueOf(state), () -> {
            Map<String, Object> providerTransferProcess = this.transferProcessClient.getTransferProcess(this.transferProcess.getCorrelationId(), this.transferProcess.getCallbackAddress());
            String actual = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/state", providerTransferProcess);
            return ("https://w3id.org/dspace/2025/1/" + state.toString()).equals(actual);
        });
        return this;
    }

    @Override
    protected void suspended(String id) {
        this.consumerConnector.getConsumerTransferProcessManager().suspended(id);
    }

    @Override
    protected void completed(String id) {
        this.consumerConnector.getConsumerTransferProcessManager().completed(id);
    }

    @Override
    protected void terminated(String id) {
        this.consumerConnector.getConsumerTransferProcessManager().terminated(id);
    }

    @Override
    protected void started(String id) {
        this.consumerConnector.getConsumerTransferProcessManager().started(id);
    }
}

