/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.pipeline;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.core.api.system.CallbackEndpoint;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ProviderNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.client.cn.ProviderNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.pipeline.AbstractNegotiationPipeline;
import org.junit.jupiter.api.Assertions;

public class ProviderNegotiationPipelineImpl
extends AbstractNegotiationPipeline<ProviderNegotiationPipeline>
implements ProviderNegotiationPipeline {
    private static final String NEGOTIATIONS_OFFER_PATH = "/negotiations/[^/]+/offers/";
    private static final String NEGOTIATIONS_AGREEMENT_PATH = "/negotiations/[^/]+/agreement";
    private static final String NEGOTIATIONS_TERMINATION_PATH = "/negotiations/[^/]+/termination/";
    private static final String NEGOTIATION_EVENT_PATH = "/negotiations/[^/]+/events";
    private final Connector consumerConnector;
    private final String providerBaseUrl;
    private final String providerConnectorId;
    private final ProviderNegotiationClient negotiationClient;

    public ProviderNegotiationPipelineImpl(ProviderNegotiationClient negotiationClient, CallbackEndpoint endpoint, Connector connector, String providerBaseUrl, String providerConnectorId, Monitor monitor, long waitTime) {
        super(negotiationClient, endpoint, monitor, waitTime);
        this.negotiationClient = negotiationClient;
        this.consumerConnector = connector;
        this.providerBaseUrl = providerBaseUrl;
        this.providerConnectorId = providerConnectorId;
        this.monitor = monitor;
    }

    public ProviderNegotiationPipeline sendRequestMessage(String datasetId, String offerId) {
        this.stages.add(() -> {
            this.providerNegotiation = this.consumerConnector.getConsumerNegotiationManager().createNegotiation(datasetId, offerId, this.providerBaseUrl);
            Map contractRequest = NegotiationFunctions.createContractRequest((String)this.providerNegotiation.getId(), (String)offerId, (String)datasetId, (String)this.endpoint.getAddress());
            this.monitor.debug("Sending contract request");
            Map<String, Object> response = this.negotiationClient.contractRequest(contractRequest, this.providerConnectorId, false);
            String correlationId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", response);
            this.consumerConnector.getConsumerNegotiationManager().contractRequested(this.providerNegotiation.getId(), correlationId);
        });
        return this;
    }

    public ProviderNegotiationPipeline sendCounterOfferMessage(String offerId, String targetId) {
        return this.sendCounterOfferMessage(offerId, targetId, false);
    }

    public ProviderNegotiationPipeline sendCounterOfferMessage(String offerId, String targetId, boolean expectError) {
        this.stages.add(() -> {
            String providerId = this.providerNegotiation.getCorrelationId();
            String consumerId = this.providerNegotiation.getId();
            String assigner = this.providerNegotiation.getCounterPartyId();
            Map contractRequest = NegotiationFunctions.createCounterOffer((String)providerId, (String)consumerId, (String)offerId, (String)assigner, (String)"TCK_PARTICIPANT", (String)targetId);
            this.monitor.debug("Sending counter offer: " + providerId);
            if (!expectError) {
                this.consumerConnector.getConsumerNegotiationManager().counterOffered(consumerId);
            }
            this.negotiationClient.contractOfferRequest(contractRequest, this.providerConnectorId, expectError);
        });
        return this;
    }

    @Override
    protected void terminated(String id) {
        this.consumerConnector.getConsumerNegotiationManager().terminated(id);
    }

    public ProviderNegotiationPipeline acceptLastOffer() {
        this.stages.add(() -> {
            String providerId = this.providerNegotiation.getCorrelationId();
            String consumerId = this.providerNegotiation.getId();
            this.monitor.debug("Accepting offer: " + providerId);
            this.consumerConnector.getConsumerNegotiationManager().accepted(consumerId);
            this.negotiationClient.accept(NegotiationFunctions.createAcceptedEvent((String)providerId, (String)consumerId));
        });
        return this;
    }

    public ProviderNegotiationPipeline sendVerifiedEvent() {
        return this.sendVerifiedEvent(false);
    }

    public ProviderNegotiationPipeline sendVerifiedEvent(boolean expectError) {
        this.stages.add(() -> {
            this.pause();
            String providerId = this.providerNegotiation.getCorrelationId();
            String consumerId = this.providerNegotiation.getId();
            this.monitor.debug("Sending verification: " + providerId);
            if (!expectError) {
                this.consumerConnector.getConsumerNegotiationManager().verified(consumerId);
            }
            this.negotiationClient.verify(NegotiationFunctions.createVerification((String)providerId, (String)consumerId), expectError);
        });
        return this;
    }

    public ProviderNegotiationPipeline expectOfferMessage(Function<Map<String, Object>, Map<String, Object>> action) {
        CountDownLatch latch = new CountDownLatch(1);
        this.expectLatches.add(latch);
        this.stages.add(() -> this.endpoint.registerHandler(NEGOTIATIONS_OFFER_PATH, offer -> {
            Map negotiation = (Map)action.apply(MessageSerializer.processJsonLd((InputStream)offer));
            this.endpoint.deregisterHandler(NEGOTIATIONS_OFFER_PATH);
            latch.countDown();
            return MessageSerializer.serialize((Object)negotiation);
        }));
        return this;
    }

    public ProviderNegotiationPipeline expectAgreementMessage(Consumer<Map<String, Object>> action) {
        return (ProviderNegotiationPipeline)this.addHandlerAction(NEGOTIATIONS_AGREEMENT_PATH, action);
    }

    public ProviderNegotiationPipeline expectFinalizedEvent(Consumer<Map<String, Object>> action) {
        return (ProviderNegotiationPipeline)this.addHandlerAction(NEGOTIATION_EVENT_PATH, action);
    }

    public ProviderNegotiationPipeline expectTermination() {
        return (ProviderNegotiationPipeline)this.addHandlerAction(NEGOTIATIONS_TERMINATION_PATH, d -> this.providerNegotiation.transition(ContractNegotiation.State.TERMINATED));
    }

    public ProviderNegotiationPipeline thenVerifyNegotiation(Consumer<ContractNegotiation> consumer) {
        return (ProviderNegotiationPipeline)this.then(() -> consumer.accept(this.providerNegotiation));
    }

    public ProviderNegotiationPipeline thenVerifyState(ContractNegotiation.State state) {
        this.stages.add(() -> Assertions.assertEquals((Object)state, (Object)this.providerNegotiation.getState()));
        return this;
    }

    public ProviderNegotiationPipeline thenVerifyProviderState(ContractNegotiation.State state) {
        this.stages.add(() -> {
            this.pause();
            Map<String, Object> providerNegotiation = this.negotiationClient.getNegotiation(this.providerNegotiation.getCorrelationId());
            String actual = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/state", providerNegotiation);
            Assertions.assertEquals((Object)("https://w3id.org/dspace/2025/1/" + state.toString()), (Object)actual);
        });
        return this;
    }

    @Override
    protected ProviderNegotiationPipeline self() {
        return this;
    }
}

