/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock.tp;

import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ConsumerTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.TransferProcessListener;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.ConsumerTransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.tp.TransferProcessMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.mock.tp.AbstractTransferProcessMock;

public class ConsumerTransferProcessMockImpl
extends AbstractTransferProcessMock
implements ConsumerTransferProcessMock,
TransferProcessListener {
    private final ConsumerTransferProcessManager manager;
    private final String baseAddress;

    public ConsumerTransferProcessMockImpl(ConsumerTransferProcessManager manager, Executor executor, String baseAddress) {
        super(executor);
        this.manager = manager;
        this.baseAddress = baseAddress;
        manager.registerListener((TransferProcessListener)this);
    }

    @Override
    public void verify() {
        super.verify();
        this.manager.deregisterListener((TransferProcessListener)this);
    }

    public void recordInitializedAction(BiConsumer<String, TransferProcess> action) {
        this.recordAction(TransferProcess.State.INITIALIZED, tp -> action.accept(this.baseAddress, (TransferProcess)tp));
    }

    public void recordStartedAction(BiConsumer<String, TransferProcess> action) {
        this.recordAction(TransferProcess.State.STARTED, tp -> action.accept(this.baseAddress, (TransferProcess)tp));
    }

    public void transferInitialized(TransferProcess transferProcess) {
        this.received(TransferProcess.State.INITIALIZED, transferProcess);
    }

    private void received(TransferProcess.State state, TransferProcess transferProcess) {
        TransferProcessMock.Action action = (TransferProcessMock.Action)this.actions.getOrDefault(state, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)transferProcess));
    }
}

