/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock;

import java.util.concurrent.Executor;
import org.eclipse.dataspacetck.dsp.system.api.connector.NegotiationListener;
import org.eclipse.dataspacetck.dsp.system.api.connector.ProviderNegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.mock.NegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.mock.ProviderNegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.mock.AbstractNegotiationMock;

public class ProviderNegotiationMockImpl
extends AbstractNegotiationMock
implements ProviderNegotiationMock,
NegotiationListener {
    private final ProviderNegotiationManager manager;

    public ProviderNegotiationMockImpl(ProviderNegotiationManager manager, Executor executor) {
        super(executor);
        this.manager = manager;
        manager.registerListener((NegotiationListener)this);
    }

    public void recordContractRequestedAction(NegotiationMock.Action action) {
        this.recordAction(ContractNegotiation.State.REQUESTED, action);
    }

    public void recordAgreedAction(NegotiationMock.Action action) {
        this.recordAction(ContractNegotiation.State.ACCEPTED, action);
    }

    public void recordVerifiedAction(NegotiationMock.Action action) {
        this.recordAction(ContractNegotiation.State.VERIFIED, action);
    }

    @Override
    public void verify() {
        super.verify();
        this.manager.deregisterListener((NegotiationListener)this);
    }

    public void contractRequested(ContractNegotiation negotiation) {
        NegotiationMock.Action action = (NegotiationMock.Action)this.actions.getOrDefault(ContractNegotiation.State.REQUESTED, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)negotiation));
    }

    public void agreed(ContractNegotiation negotiation) {
        NegotiationMock.Action action = (NegotiationMock.Action)this.actions.getOrDefault(ContractNegotiation.State.ACCEPTED, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)negotiation));
    }

    public void verified(ContractNegotiation negotiation) {
        NegotiationMock.Action action = (NegotiationMock.Action)this.actions.getOrDefault(ContractNegotiation.State.VERIFIED, EMPTY_QUEUE).poll();
        if (action == null) {
            return;
        }
        this.executor.execute(() -> action.accept((Object)negotiation));
    }
}

