/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.mock;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.dataspacetck.dsp.system.api.mock.NegotiationMock;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.mockito.internal.util.StringUtil;

public abstract class AbstractNegotiationMock
implements NegotiationMock {
    protected Executor executor;
    protected static final Queue<NegotiationMock.Action> EMPTY_QUEUE = new ArrayDeque<NegotiationMock.Action>();
    protected Map<ContractNegotiation.State, Queue<NegotiationMock.Action>> actions = new ConcurrentHashMap<ContractNegotiation.State, Queue<NegotiationMock.Action>>();

    public AbstractNegotiationMock(Executor executor) {
        this.executor = executor;
    }

    public void verify() {
        List actions;
        if (!this.actions.isEmpty() && !(actions = this.actions.entrySet().stream().filter(e -> !((Queue)e.getValue()).isEmpty()).map(e -> ((ContractNegotiation.State)e.getKey()).toString()).collect(Collectors.toList())).isEmpty()) {
            throw new AssertionError((Object)String.format("Request actions not executed.\n Actions: %s", StringUtil.join((String)", ", actions)));
        }
    }

    public boolean completed() {
        return this.actions.isEmpty();
    }

    public void reset() {
        this.actions.clear();
    }

    protected void recordAction(ContractNegotiation.State state, NegotiationMock.Action action) {
        this.actions.computeIfAbsent(state, k -> new ConcurrentLinkedQueue()).add(action);
    }
}

