/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector.tp;

import java.util.Map;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.tp.ProviderTransferProcessManager;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.tp.TransferFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.TransferProcess;
import org.eclipse.dataspacetck.dsp.system.connector.tp.AbstractTransferProcessManager;

public class ProviderTransferProcessManagerImpl
extends AbstractTransferProcessManager
implements ProviderTransferProcessManager {
    private final Monitor monitor;

    public ProviderTransferProcessManagerImpl(Monitor monitor) {
        super(monitor);
        this.monitor = monitor;
    }

    public Map<String, Object> handleTransferRequest(Map<String, Object> transferRequest, String counterPartyId) {
        String consumerPid = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", transferRequest);
        this.monitor.debug("Received transfer request message with consumer pid: " + consumerPid);
        TransferProcess prevTransfer = this.findByCorrelationId(consumerPid);
        if (prevTransfer != null) {
            return TransferFunctions.createTransferResponse((String)prevTransfer.getId(), (String)prevTransfer.getCorrelationId(), (String)prevTransfer.getState().toString());
        }
        String callbackAddress = JsonLdFunctions.stringProperty((String)"https://w3id.org/dspace/2025/1/callbackAddress", transferRequest);
        TransferProcess transfer = TransferProcess.Builder.newInstance().correlationId(consumerPid).state(TransferProcess.State.REQUESTED).callbackAddress(callbackAddress).transferKind(TransferProcess.TransferKind.Provider).build();
        this.transferProcesses.put(transfer.getId(), transfer);
        this.listeners.forEach(l -> l.requested(transfer));
        return TransferFunctions.createTransferResponse((String)transfer.getId(), (String)transfer.getCorrelationId(), (String)transfer.getState().toString());
    }

    @Override
    protected AbstractTransferProcessManager.TransferId parseId(Map<String, Object> message) {
        String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", message);
        String consumerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/consumerPid", message);
        return new AbstractTransferProcessManager.TransferId(providerId, consumerId);
    }
}

