/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.connector;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.connector.NegotiationListener;
import org.eclipse.dataspacetck.dsp.system.api.connector.NegotiationManager;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNegotiationManager
implements NegotiationManager {
    private final Monitor monitor;
    protected Map<String, ContractNegotiation> negotiations = new ConcurrentHashMap<String, ContractNegotiation>();
    protected Queue<NegotiationListener> listeners = new ConcurrentLinkedQueue<NegotiationListener>();

    protected AbstractNegotiationManager(Monitor monitor) {
        this.monitor = monitor;
    }

    @NotNull
    public ContractNegotiation findById(String id) {
        ContractNegotiation negotiation = this.negotiations.get(id);
        if (negotiation == null) {
            throw new IllegalArgumentException("Contract negotiation not found for id: " + id);
        }
        return negotiation;
    }

    @Nullable
    public ContractNegotiation findByCorrelationId(String id) {
        return this.negotiations.values().stream().filter(n -> id.equals(n.getCorrelationId())).findAny().orElse(null);
    }

    public Map<String, ContractNegotiation> getNegotiations() {
        return this.negotiations;
    }

    public void registerListener(NegotiationListener listener) {
        this.listeners.add(listener);
    }

    public void deregisterListener(NegotiationListener listener) {
        this.listeners.remove(listener);
    }

    public Map<String, Object> handleTermination(Map<String, Object> terminatedMessage) {
        NegotiationId ids = this.parseId(terminatedMessage);
        this.monitor.debug(String.format("Received terminated message: %s with correlation id %s", ids.id, ids.correlationId));
        ContractNegotiation negotiation = this.findById(ids.id);
        negotiation.transition(ContractNegotiation.State.TERMINATED, n -> this.listeners.forEach(l -> l.terminated(negotiation)));
        return NegotiationFunctions.createNegotiationResponse((String)negotiation.getCorrelationId(), (String)negotiation.getId(), (String)ContractNegotiation.State.TERMINATED.toString());
    }

    protected abstract NegotiationId parseId(Map<String, Object> var1);

    public void terminated(String id) {
        ContractNegotiation cn = this.findById(id);
        cn.transition(ContractNegotiation.State.TERMINATED, n -> this.listeners.forEach(l -> l.terminated(n)));
    }

    protected record NegotiationId(String id, String correlationId) {
    }
}

